/*
 * Decompiled with CFR 0.152.
 */
package javatunnel;

import dmg.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import javatunnel.Convertable;
import javatunnel.GssTunnel;
import javax.security.auth.Subject;
import org.dcache.auth.FQANPrincipal;
import org.dcache.auth.util.GSSUtils;
import org.dcache.util.Crypto;
import org.dcache.util.Files;
import org.glite.voms.FQAN;
import org.glite.voms.PKIVerifier;
import org.globus.gsi.CredentialException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.X509Credential;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class GsiTunnel
extends GssTunnel {
    private static final Logger _log = LoggerFactory.getLogger(GsiTunnel.class);
    private ExtendedGSSContext _e_context;
    private static final String SERVICE_KEY = "service_key";
    private static final String SERVICE_CERT = "service_cert";
    private static final String SERVICE_TRUSTED_CERTS = "service_trusted_certs";
    private static final String SERVICE_VOMS_DIR = "service_voms_dir";
    private static final String CIPHER_FLAGS = "ciphers";
    private final Args _arguments;
    private PKIVerifier _pkiVerifier;
    private Subject _subject = new Subject();

    public GsiTunnel(String args) throws GSSException, IOException {
        this(args, true);
    }

    public GsiTunnel(String args, boolean init) throws GSSException, IOException {
        this._arguments = new Args((CharSequence)args);
        if (init) {
            X509Credential serviceCredential;
            String service_key = this._arguments.getOption(SERVICE_KEY);
            String service_cert = this._arguments.getOption(SERVICE_CERT);
            String service_trusted_certs = this._arguments.getOption(SERVICE_TRUSTED_CERTS);
            String service_voms_dir = this._arguments.getOption(SERVICE_VOMS_DIR);
            Files.checkFile((String)service_key);
            Files.checkFile((String)service_cert);
            Files.checkDirectory((String)service_trusted_certs);
            try {
                this._pkiVerifier = GSSUtils.getPkiVerifier((String)service_voms_dir, (String)service_trusted_certs, (Map)MDC.getCopyOfContextMap());
            }
            catch (Exception e) {
                throw new GSSException(11, 0, e.getMessage());
            }
            try {
                serviceCredential = new X509Credential(service_cert, service_key);
            }
            catch (CredentialException e) {
                throw new GSSException(13, 0, e.getMessage());
            }
            catch (IOException ioe) {
                throw new GSSException(13, 0, "could not load host globus credentials " + ioe.toString());
            }
            GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(serviceCredential, 2);
            GSSManager manager = ExtendedGSSManager.getInstance();
            this._e_context = (ExtendedGSSContext)manager.createContext((GSSCredential)cred);
            this._e_context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
            this._e_context.setBannedCiphers(Crypto.getBannedCipherSuitesFromConfigurationValue((String)this._arguments.getOption(CIPHER_FLAGS)));
            this._context = this._e_context;
            super.useChannelBinding(false);
        }
    }

    @Override
    public boolean verify(InputStream in, OutputStream out, Object addon) {
        try {
            if (super.verify(in, out, addon)) {
                X509Certificate[] chain = (X509Certificate[])this._e_context.inquireByOid(GSSConstants.X509_CERT_CHAIN);
                this._subject.getPublicCredentials().add(chain);
                this._subject.getPrincipals().add((Principal)new GlobusPrincipal(this._e_context.getSrcName().toString()));
                this.scanExtendedAttributes(this._e_context);
            }
        }
        catch (GSSException e) {
            _log.error("Failed to verify: {}", (Object)e.toString());
        }
        return this._context.isEstablished();
    }

    @Override
    public Convertable makeCopy() throws IOException {
        try {
            return new GsiTunnel(this._arguments.toString(), true);
        }
        catch (GSSException e) {
            throw new IOException(e);
        }
    }

    private void scanExtendedAttributes(ExtendedGSSContext gssContext) {
        try {
            Iterator fqans = GSSUtils.getFQANsFromGSSContext((ExtendedGSSContext)gssContext, (PKIVerifier)this._pkiVerifier).iterator();
            boolean primary = true;
            while (fqans.hasNext()) {
                String fqanValue = (String)fqans.next();
                FQAN fqan = new FQAN(fqanValue);
                String group = fqan.getGroup();
                String role = fqan.getRole();
                String s = role == null || role.equals("") ? group : group + "/Role=" + role;
                this._subject.getPrincipals().add((Principal)new FQANPrincipal(s, primary));
                primary = false;
            }
        }
        catch (AuthorizationException e) {
            _log.error("Failed to get users group and role context: {}", (Object)e.toString());
        }
    }

    @Override
    public Subject getSubject() {
        return this._subject;
    }
}

