/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.core.store.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.masukomi.aspirin.core.config.Configuration;
import org.masukomi.aspirin.core.listener.ListenerManager;
import org.masukomi.aspirin.core.store.queue.DeliveryState;
import org.masukomi.aspirin.core.store.queue.QueueInfo;
import org.masukomi.aspirin.core.store.queue.QueueStore;

public class SimpleQueueStore
implements QueueStore {
    private final Configuration configuration;
    private final ListenerManager listenerManager;
    private List<QueueInfo> queueInfoList = new LinkedList<QueueInfo>();
    private Map<String, QueueInfo> queueInfoByMailidAndRecipient = new HashMap<String, QueueInfo>();
    private Map<String, List<QueueInfo>> queueInfoByMailid = new HashMap<String, List<QueueInfo>>();
    private Map<String, List<QueueInfo>> queueInfoByRecipient = new HashMap<String, List<QueueInfo>>();
    private Object lock = new Object();
    private Comparator<QueueInfo> queueInfoComparator = new Comparator<QueueInfo>(){

        @Override
        public int compare(QueueInfo o1, QueueInfo o2) {
            return (int)(o2.getAttempt() - o1.getAttempt());
        }
    };

    public SimpleQueueStore(Configuration configuration, ListenerManager listenerManager) {
        this.configuration = configuration;
        this.listenerManager = listenerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void add(String mailid, long expiry, Collection<InternetAddress> recipients) throws MessagingException {
        try {
            for (InternetAddress recipient : recipients) {
                QueueInfo queueInfo = new QueueInfo(this.configuration, this.listenerManager);
                queueInfo.setExpiry(expiry);
                queueInfo.setMailid(mailid);
                queueInfo.setRecipient(recipient.getAddress());
                Object object = this.lock;
                synchronized (object) {
                    this.queueInfoList.add(queueInfo);
                    this.queueInfoByMailidAndRecipient.put(this.createSearchKey(queueInfo.getMailid(), queueInfo.getRecipient()), queueInfo);
                    if (!this.queueInfoByMailid.containsKey(queueInfo.getMailid())) {
                        this.queueInfoByMailid.put(queueInfo.getMailid(), new ArrayList());
                    }
                    this.queueInfoByMailid.get(queueInfo.getMailid()).add(queueInfo);
                    if (!this.queueInfoByRecipient.containsKey(queueInfo.getRecipient())) {
                        this.queueInfoByRecipient.put(queueInfo.getRecipient(), new ArrayList());
                    }
                    this.queueInfoByRecipient.get(queueInfo.getRecipient()).add(queueInfo);
                }
            }
            return;
        }
        catch (Exception e) {
            throw new MessagingException("Message queueing failed: " + mailid, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> clean() {
        ArrayList<String> mailidList = null;
        Object object = this.lock;
        synchronized (object) {
            mailidList = new ArrayList<String>(this.queueInfoByMailid.keySet());
        }
        Iterator mailidIt = mailidList.iterator();
        while (mailidIt.hasNext()) {
            String mailid = (String)mailidIt.next();
            if (!this.isCompleted(mailid)) continue;
            this.remove(mailid);
            mailidIt.remove();
        }
        return mailidList;
    }

    @Override
    public QueueInfo createQueueInfo() {
        return new QueueInfo(this.configuration, this.listenerManager);
    }

    @Override
    public long getNextAttempt(String mailid, String recipient) {
        QueueInfo qInfo = this.queueInfoByMailidAndRecipient.get(this.createSearchKey(mailid, recipient));
        if (qInfo != null && qInfo.hasState(DeliveryState.QUEUED)) {
            return qInfo.getAttempt();
        }
        return -1L;
    }

    @Override
    public boolean hasBeenRecipientHandled(String mailid, String recipient) {
        QueueInfo qInfo = this.queueInfoByMailidAndRecipient.get(this.createSearchKey(mailid, recipient));
        return qInfo != null && qInfo.hasState(DeliveryState.FAILED, DeliveryState.SENT);
    }

    @Override
    public void init() {
    }

    @Override
    public boolean isCompleted(String mailid) {
        List<QueueInfo> qibmList = this.queueInfoByMailid.get(mailid);
        if (qibmList != null) {
            for (QueueInfo sqi : qibmList) {
                if (!sqi.hasState(DeliveryState.IN_PROGRESS, DeliveryState.QUEUED)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueInfo next() {
        Collections.sort(this.queueInfoList, this.queueInfoComparator);
        if (!this.queueInfoList.isEmpty()) {
            Object object = this.lock;
            synchronized (object) {
                ListIterator<QueueInfo> queueInfoIt = this.queueInfoList.listIterator();
                while (queueInfoIt.hasNext()) {
                    QueueInfo qi = queueInfoIt.next();
                    if (!qi.isSendable()) continue;
                    if (!qi.isInTimeBounds()) {
                        if (qi.getResultInfo() == null || qi.getResultInfo().isEmpty()) {
                            qi.setResultInfo("Delivery is out of time or attempt.");
                        }
                        qi.setState(DeliveryState.FAILED);
                        this.setSendingResult(qi);
                        continue;
                    }
                    qi.setState(DeliveryState.IN_PROGRESS);
                    return qi;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String mailid) {
        Object object = this.lock;
        synchronized (object) {
            List<QueueInfo> removeableQueueInfos = this.queueInfoByMailid.remove(mailid);
            if (removeableQueueInfos != null) {
                for (QueueInfo sqi : removeableQueueInfos) {
                    this.queueInfoByMailidAndRecipient.remove(this.createSearchKey(sqi.getMailid(), sqi.getRecipient()));
                    this.queueInfoByRecipient.get(sqi.getRecipient()).remove(sqi);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRecipient(String recipient) {
        Object object = this.lock;
        synchronized (object) {
            List<QueueInfo> removeableQueueInfos = this.queueInfoByRecipient.remove(recipient);
            if (removeableQueueInfos != null) {
                for (QueueInfo sqi : removeableQueueInfos) {
                    this.queueInfoByMailidAndRecipient.remove(this.createSearchKey(sqi.getMailid(), sqi.getRecipient()));
                    this.queueInfoByMailid.get(sqi.getMailid()).remove(sqi);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSendingResult(QueueInfo qi) {
        Object object = this.lock;
        synchronized (object) {
            QueueInfo uniqueQueueInfo = this.queueInfoByMailidAndRecipient.get(this.createSearchKey(qi.getMailid(), qi.getRecipient()));
            if (uniqueQueueInfo != null) {
                uniqueQueueInfo.setAttempt(System.currentTimeMillis() + (long)this.configuration.getDeliveryAttemptDelay());
                uniqueQueueInfo.incAttemptCount();
                uniqueQueueInfo.setState(qi.getState());
            }
        }
    }

    @Override
    public int size() {
        return this.queueInfoByMailid.size();
    }

    private String createSearchKey(String mailid, String recipient) {
        return mailid + "-" + recipient;
    }
}

