/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.core.store.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.masukomi.aspirin.core.Helper;
import org.masukomi.aspirin.core.config.Configuration;
import org.masukomi.aspirin.core.store.mail.MailStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMailStore
implements MailStore {
    private static final Logger log = LoggerFactory.getLogger(FileMailStore.class);
    private final Helper helper;
    private File rootDir;
    private int subDirCount = 3;
    private Random rand = new Random();
    private Map<String, WeakReference<MimeMessage>> messageMap = new HashMap<String, WeakReference<MimeMessage>>();
    private Map<String, String> messagePathMap = new HashMap<String, String>();

    public FileMailStore(Configuration configuration) {
        this.helper = new Helper(configuration);
    }

    @Override
    public MimeMessage get(String mailid) {
        WeakReference<MimeMessage> msgRef = this.messageMap.get(mailid);
        MimeMessage msg = null;
        if (msgRef != null && (msg = (MimeMessage)msgRef.get()) == null) {
            try {
                msg = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties()), (InputStream)new FileInputStream(new File(this.messagePathMap.get(mailid))));
                msgRef = new WeakReference<MimeMessage>(msg);
            }
            catch (FileNotFoundException e) {
                log.error(this.getClass().getSimpleName() + " No file representation found for name " + mailid, (Throwable)e);
            }
            catch (MessagingException e) {
                log.error(this.getClass().getSimpleName() + " There is a messaging exception with name " + mailid, (Throwable)e);
            }
        }
        return msg;
    }

    @Override
    public List<String> getMailIds() {
        return new ArrayList<String>(this.messageMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (!this.rootDir.exists()) {
            return;
        }
        File[] subdirs = this.rootDir.listFiles();
        if (subdirs == null) {
            return;
        }
        for (File subDir : subdirs) {
            File[] subdirFiles;
            if (!subDir.isDirectory() || (subdirFiles = subDir.listFiles()) == null) continue;
            for (File msgFile : subdirFiles) {
                try {
                    MimeMessage msg = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties()), (InputStream)new FileInputStream(msgFile));
                    String mailid = this.helper.getMailID(msg);
                    Map<String, WeakReference<MimeMessage>> map = this.messageMap;
                    synchronized (map) {
                        this.messageMap.put(mailid, new WeakReference<MimeMessage>(msg));
                        this.messagePathMap.put(mailid, msgFile.getAbsolutePath());
                    }
                }
                catch (FileNotFoundException e) {
                    log.error(this.getClass().getSimpleName() + " No file representation found with name " + msgFile.getAbsolutePath(), (Throwable)e);
                }
                catch (MessagingException e) {
                    log.error(this.getClass().getSimpleName() + " There is a messaging exception in file " + msgFile.getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String mailid) {
        Map<String, WeakReference<MimeMessage>> map = this.messageMap;
        synchronized (map) {
            this.messageMap.remove(mailid);
            Map<String, String> map2 = this.messagePathMap;
            synchronized (map2) {
                File f = new File(this.messagePathMap.get(mailid));
                f.delete();
                this.messagePathMap.remove(mailid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String mailid, MimeMessage msg) {
        if (this.rootDir == null) {
            throw new RuntimeException(this.getClass().getSimpleName() + " Please set up root directory.");
        }
        String subDirName = String.valueOf(this.rand.nextInt(this.subDirCount));
        File dir = new File(this.rootDir, subDirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String filepath = new File(dir, mailid + ".msg").getAbsolutePath();
        try {
            File msgFile = new File(filepath);
            if (msgFile.exists()) {
                msgFile.delete();
            }
            if (!msgFile.exists()) {
                msgFile.createNewFile();
            }
            msg.writeTo((OutputStream)new FileOutputStream(msgFile));
            Map<String, WeakReference<MimeMessage>> map = this.messageMap;
            synchronized (map) {
                this.messageMap.put(mailid, new WeakReference<MimeMessage>(msg));
                this.messagePathMap.put(mailid, filepath);
            }
        }
        catch (FileNotFoundException e) {
            log.error(this.getClass().getSimpleName() + " No file representation found for name " + mailid, (Throwable)e);
        }
        catch (IOException e) {
            log.error(this.getClass().getSimpleName() + " Could not write file for name " + mailid, (Throwable)e);
        }
        catch (MessagingException e) {
            log.error(this.getClass().getSimpleName() + " There is a messaging exception with name " + mailid, (Throwable)e);
        }
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setSubDirCount(int subDirCount) {
        this.subDirCount = subDirCount;
    }

    public int getSubDirCount() {
        return this.subDirCount;
    }
}

