/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import java.security.Principal;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.dcache.gplazma.util.Preconditions;

public class Krb5
implements GPlazmaMappingPlugin {
    public Krb5(Properties properties) {
    }

    public void map(Set<Principal> principals) throws AuthenticationException {
        HashSet<UserNamePrincipal> kerberosPrincipals = new HashSet<UserNamePrincipal>();
        for (Principal principal : principals) {
            if (!(principal instanceof KerberosPrincipal)) continue;
            kerberosPrincipals.add(new UserNamePrincipal(this.stripDomain(principal.getName())));
        }
        Preconditions.checkAuthentication((!kerberosPrincipals.isEmpty() ? 1 : 0) != 0, (String)"no Kerberos principals");
        principals.addAll(kerberosPrincipals);
    }

    private String stripDomain(String s) {
        int n = s.indexOf(64);
        if (n != -1) {
            return s.substring(0, n);
        }
        return s;
    }
}

