/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.provider;

import java.security.KeyStore;

public class KeyStoreParametersFactory {
    public static KeyStore.LoadStoreParameter createCertKeyParameters(String certLocations, String keyLocation) {
        return new CertKeyParameters(certLocations, keyLocation);
    }

    public static KeyStore.LoadStoreParameter createProxyCertParameters(String proxyCertLocation) {
        return new ProxyCertParameters(proxyCertLocation);
    }

    public static KeyStore.LoadStoreParameter createTrustStoreParameters(String trustedCertificateDirectories) {
        return new TrustStoreParameters(trustedCertificateDirectories, null);
    }

    public static KeyStore.LoadStoreParameter createTrustStoreParameters(String trustedCertificateDirectories, String defaultDirectory) {
        return new TrustStoreParameters(trustedCertificateDirectories, defaultDirectory);
    }

    public static interface FileStoreParameters
    extends KeyStore.LoadStoreParameter {
        public Object getProperty(String var1);
    }

    private static class CertKeyParameters
    implements FileStoreParameters {
        private String certLocations;
        private String keyLocation;
        private KeyStore.ProtectionParameter param;

        public CertKeyParameters(String certLocations, String keyLocation) {
            this.certLocations = certLocations;
            this.keyLocation = keyLocation;
        }

        public KeyStore.ProtectionParameter getProtectionParameter() {
            return this.param;
        }

        public Object getProperty(String key) {
            if (key.equals("keyFilename")) {
                return this.keyLocation;
            }
            if (key.equals("certificateFilename")) {
                return this.certLocations;
            }
            return null;
        }
    }

    private static class ProxyCertParameters
    implements FileStoreParameters {
        private String proxyLocation;

        public ProxyCertParameters(String proxyLocation) {
            this.proxyLocation = proxyLocation;
        }

        public Object getProperty(String key) {
            if (key.equals("proxyFilename")) {
                return this.proxyLocation;
            }
            return null;
        }

        public KeyStore.ProtectionParameter getProtectionParameter() {
            return null;
        }
    }

    private static class TrustStoreParameters
    implements FileStoreParameters {
        private String trustedCertificateDirectories;
        private String defaultCertificateDirectory;

        public TrustStoreParameters(String trustedCertificateDirectories, String defaultCertificateDirectory) {
            this.trustedCertificateDirectories = trustedCertificateDirectories;
            this.defaultCertificateDirectory = defaultCertificateDirectory;
        }

        public Object getProperty(String key) {
            if (key.equals("directory_list")) {
                return this.trustedCertificateDirectories;
            }
            if (key.equals("default_directory")) {
                return this.defaultCertificateDirectory;
            }
            return null;
        }

        public KeyStore.ProtectionParameter getProtectionParameter() {
            return null;
        }
    }
}

