/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tuple;

import hep.aida.IManagedObject;
import hep.aida.ITuple;
import hep.aida.ref.tuple.AbstractTuple;
import hep.aida.ref.tuple.FTuple;
import hep.aida.ref.tuple.ReadOnlyAbstractTuple;
import hep.aida.ref.tuple.Tuple;
import org.freehep.util.Value;

public class ChainedTuple
extends ReadOnlyAbstractTuple {
    private ITuple[] set;
    private int currentRow;
    private ITuple currentTuple;
    private int currentTupleID;
    private int currentTupleRow;
    private ChainedTuple[] tuples;

    public ChainedTuple(String name, String title, ITuple[] set) {
        super(name, title);
        int nCol = 0;
        if (set.length > 1) {
            nCol = set[0].columns();
            String[] colNames = new String[nCol];
            Class[] colTypes = new Class[nCol];
            for (int i = 0; i < nCol; ++i) {
                colNames[i] = set[0].columnName(i);
                colTypes[i] = set[0].columnType(i);
            }
            for (int n = 1; n < set.length; ++n) {
                if (set[n].columns() != nCol) {
                    throw new IllegalArgumentException("ITuples in the set have different number of columns!");
                }
                for (int i = 0; i < nCol; ++i) {
                    if (!colNames[i].equals(set[n].columnName(i))) {
                        throw new IllegalArgumentException("ITuples in the set have different column names!");
                    }
                    if (colTypes[i] == set[n].columnType(i)) continue;
                    throw new IllegalArgumentException("ITuples in the set have different column types!");
                }
            }
        } else {
            throw new IllegalArgumentException("Not enough tuples provided. Two or more tuples must be chained together.");
        }
        this.tuples = new ChainedTuple[nCol];
        for (int i = 0; i < nCol; ++i) {
            if (set[0].columnType(i) != ITuple.class) continue;
            ITuple[] folders = new ITuple[set.length];
            for (int j = 0; j < set.length; ++j) {
                set[j].start();
                folders[j] = set[j].findTuple(i);
            }
            this.tuples[i] = new ChainedTuple(set[0].columnName(i), "", folders);
        }
        this.setTitle(title);
        this.set = set;
        this.currentRow = -1;
        this.currentTuple = set[0];
        this.currentTuple.start();
        this.currentTupleID = 0;
        this.currentTupleRow = -1;
    }

    @Override
    public boolean supportsRandomAccess() {
        int i = 0;
        if (i < this.set.length) {
            if (this.set[i] instanceof FTuple && !((FTuple)this.set[i]).supportsRandomAccess()) {
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsMultipleCursors() {
        int i = 0;
        if (i < this.set.length) {
            if (this.set[i] instanceof FTuple && !((FTuple)this.set[i]).supportsMultipleCursors()) {
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isInMemory() {
        int i = 0;
        if (i < this.set.length) {
            if (this.set[i] instanceof FTuple && !((FTuple)this.set[i]).isInMemory()) {
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean providesColumnDefaultValues() {
        int i = 0;
        if (i < this.set.length) {
            if (this.set[i] instanceof AbstractTuple && !((AbstractTuple)this.set[i]).providesColumnDefaultValues()) {
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public void columnValue(int column, Value v) {
        Class type = this.currentTuple.columnType(column);
        if (type == Integer.TYPE) {
            v.set(this.currentTuple.getInt(column));
        } else if (type == Short.TYPE) {
            v.set(this.currentTuple.getShort(column));
        } else if (type == Long.TYPE) {
            v.set(this.currentTuple.getLong(column));
        } else if (type == Float.TYPE) {
            v.set(this.currentTuple.getFloat(column));
        } else if (type == Double.TYPE) {
            v.set(this.currentTuple.getDouble(column));
        } else if (type == Boolean.TYPE) {
            v.set(this.currentTuple.getBoolean(column));
        } else if (type == Byte.TYPE) {
            v.set(this.currentTuple.getByte(column));
        } else if (type == Character.TYPE) {
            v.set(this.currentTuple.getChar(column));
        } else if (type == String.class) {
            v.set(this.currentTuple.getString(column));
        } else {
            v.set(this.currentTuple.getObject(column));
        }
    }

    @Override
    public String columnDefaultString(int column) {
        if (this.set[0] instanceof Tuple) {
            return ((Tuple)this.set[0]).columnDefaultString(column);
        }
        if (this.columnType(column) != ITuple.class) {
            return this.set[0].columnDefaultValue(column).toString();
        }
        ITuple tup = this.findTuple(column);
        if (tup != null) {
            String tupName = "";
            tupName = tup instanceof IManagedObject ? ((IManagedObject)tup).name() : tup.title();
            String tmpColumnsString = "";
            int nCol = tup.columns();
            for (int i = 0; i < nCol; ++i) {
                Class colType = tup.columnType(i);
                String colName = tup.columnName(i);
                tmpColumnsString = tmpColumnsString + colType + " " + colName;
                if (i >= nCol) continue;
                tmpColumnsString = tmpColumnsString + ";";
            }
            return tupName + " = {" + tmpColumnsString + "}";
        }
        return "null";
    }

    @Override
    public int columns() {
        return this.set[0].columns();
    }

    @Override
    public String columnName(int column) {
        return this.set[0].columnName(column);
    }

    @Override
    public Class columnType(int column) {
        return this.set[0].columnType(column);
    }

    @Override
    public double columnMin(int column) {
        double min = Double.NaN;
        for (int i = 0; i < this.set.length; ++i) {
            double tmp = this.set[i].columnMin(column);
            if (!Double.isNaN(min) && !(tmp < min)) continue;
            min = tmp;
        }
        return min;
    }

    @Override
    public double columnMax(int column) {
        double max = Double.NaN;
        for (int i = 0; i < this.set.length; ++i) {
            double tmp = this.set[i].columnMax(column);
            if (!Double.isNaN(max) && !(tmp > max)) continue;
            max = tmp;
        }
        return max;
    }

    @Override
    public double columnMean(int column) {
        double mean = 0.0;
        int rows = 0;
        for (int i = 0; i < this.set.length; ++i) {
            double m = this.set[i].columnMean(column);
            int r = this.set[i].rows();
            if (r <= 0) continue;
            if (!Double.isNaN(m)) {
                mean += m * (double)r;
                rows += r;
                continue;
            }
            return Double.NaN;
        }
        return mean / (double)rows;
    }

    @Override
    public double columnRms(int column) {
        double rms = 0.0;
        int rows = 0;
        for (int i = 0; i < this.set.length; ++i) {
            double m = this.set[i].columnMean(column);
            double rm = this.set[i].columnRms(column);
            int r = this.set[i].rows();
            if (r <= 0) continue;
            if (!Double.isNaN(m) && !Double.isNaN(rm)) {
                rms += (rm * rm + m * m) * (double)r;
                rows += r;
                continue;
            }
            return Double.NaN;
        }
        return Math.sqrt(rms / (double)rows - Math.pow(this.columnMean(column), 2.0));
    }

    @Override
    public int rows() {
        int rows = 0;
        for (int i = 0; i < this.set.length; ++i) {
            int r = this.set[i].rows();
            if (r <= 0) continue;
            rows += r;
        }
        return rows;
    }

    @Override
    public int getRow() {
        return this.currentRow;
    }

    @Override
    public ITuple findTuple(int column) {
        return this.tuples[column];
    }

    @Override
    public void setRow(int row) {
        if (row > this.rows()) {
            throw new IllegalArgumentException("Row " + row + " is bigger than the length of this ChainedTuple (" + this.rows() + ")");
        }
        int rows = 0;
        int i = 0;
        int r = 0;
        Object tup = null;
        for (i = 0; i < this.set.length; ++i) {
            r = this.set[i].rows();
            if (rows < row && rows + r > row) break;
            if (r <= 0) continue;
            rows += r;
        }
        this.currentRow = row;
        this.currentTupleID = i;
        this.currentTuple = this.set[this.currentTupleID];
        this.currentTupleRow = row - rows;
        this.currentTuple.setRow(this.currentTupleRow);
    }

    @Override
    public void start() {
        this.currentRow = -1;
        this.currentTupleID = 0;
        this.currentTuple = this.set[this.currentTupleID];
        this.currentTuple.start();
        this.currentTupleRow = -1;
    }

    @Override
    public void skip(int rows) {
        this.setRow(this.currentRow + rows);
    }

    @Override
    public boolean next() {
        if (this.currentTuple.next()) {
            ++this.currentRow;
            ++this.currentTupleRow;
            return true;
        }
        if (this.currentTupleID < this.set.length - 1) {
            ++this.currentTupleID;
            this.currentTuple = this.set[this.currentTupleID];
            this.currentTuple.start();
            this.currentTupleRow = 0;
            if (!this.currentTuple.next()) {
                return this.next();
            }
            ++this.currentRow;
            return true;
        }
        return false;
    }

    @Override
    public int findColumn(String name) throws IllegalArgumentException {
        return this.set[0].findColumn(name);
    }

    @Override
    public Object columnDefaultValue(int column) {
        return this.set[0].columnDefaultValue(column);
    }
}

