/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.style.registry.BaseStyleStore;
import hep.aida.ref.plotter.style.registry.StyleStoreXMLWriter;
import java.io.File;

public class XMLStyleStore
extends BaseStyleStore {
    public static String TYPE = "XMLStyleStore";
    private String commitFileName;

    public XMLStyleStore(String storeName) {
        this(storeName, TYPE);
    }

    public XMLStyleStore(String storeName, String storeType) {
        this(storeName, storeType, true);
    }

    public XMLStyleStore(String storeName, String storeType, boolean isReadOnly) {
        super(storeName);
        this.storeType = storeType;
        this.isReadOnly = isReadOnly;
    }

    public XMLStyleStore(String storeName, IPlotterStyle[] styles, boolean isReadOnly) {
        super(storeName);
        this.storeType = TYPE;
        this.isReadOnly = isReadOnly;
        for (int i = 0; i < styles.length; ++i) {
            String name = "Style_" + i;
            try {
                String tmp = styles[i].parameterValue("plotterStyleName");
                if (tmp != null && !tmp.trim().equals("")) {
                    name = tmp;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.addStyle(name, styles[i]);
        }
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public String getCommitFileName() {
        return this.commitFileName;
    }

    public void setCommitFileName(String commitFileName) {
        this.commitFileName = commitFileName != null && commitFileName.trim().equals("") ? null : commitFileName;
    }

    @Override
    public boolean isReadOnly() {
        return this.commitFileName == null || this.isReadOnly;
    }

    @Override
    public void commit() {
        if (this.isReadOnly) {
            throw new UnsupportedOperationException("XMLStyleStore " + this.getStoreName() + " :: setup as a Read-Only store, can not commit");
        }
        if (this.commitFileName == null) {
            throw new UnsupportedOperationException("XMLStyleStore " + this.getStoreName() + " :: Commit File Name is NULL, can not commit");
        }
        File file = new File(this.commitFileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            if (!file.canWrite()) {
                throw new UnsupportedOperationException("XMLStyleStore " + this.getStoreName() + " :: Commit File \"" + this.commitFileName + "\" is Read-Only, can not commit");
            }
            StyleStoreXMLWriter.writeToFile(this.commitFileName, this, false);
        }
        catch (UnsupportedOperationException uoe) {
            throw uoe;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        this.commitFileName = null;
        super.close();
    }

    public static void main(String[] args) {
    }
}

