/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf.examples;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud1D;
import hep.aida.IFitFactory;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogramFactory;
import hep.aida.IPlotter;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.ref.pdf.FunctionMcStudy;
import hep.aida.ref.pdf.Gaussian;
import java.util.Random;

public class GaussianMCStudy {
    public static void main(String[] args) {
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create();
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        ITupleFactory tupleFactory = analysisFactory.createTupleFactory(tree);
        IFunctionFactory functionFactory = analysisFactory.createFunctionFactory(tree);
        IFitFactory fitFactory = analysisFactory.createFitFactory();
        IPlotter plotter = analysisFactory.createPlotterFactory().create("Plotter");
        ICloud1D c1 = histogramFactory.createCloud1D("Cloud 1D");
        Random r_1 = new Random(123L);
        Random r_2 = new Random(456L);
        int entries = 10000;
        for (int i = 0; i < entries; ++i) {
            double x = r_1.nextGaussian();
            c1.fill(x);
        }
        plotter.show();
        plotter.region(0).plot((IBaseHistogram)c1);
        Gaussian gaussian = new Gaussian("Gaussian");
        ITuple tuple = FunctionMcStudy.generateTuple(gaussian, entries);
        ICloud1D mcGauss = histogramFactory.createCloud1D("Mc Gauss");
        String[] columnNames = tuple.columnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            System.out.println("*** " + columnNames[i]);
        }
    }
}

