/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.FunctionCore;
import jas.hist.Handle;
import java.awt.Cursor;
import org.freehep.util.images.ImageHandler;

public class PolynomialCoreNotNorm
extends FunctionCore {
    protected boolean providesNormalization;
    private double[] tmpVar = new double[1];

    public PolynomialCoreNotNorm(int dim, int nPar) {
        super(dim, nPar);
        this.setTitle("PolynomialCoreNotNorm::P" + nPar);
        this.providesNormalization = false;
    }

    public PolynomialCoreNotNorm(int dim, int nPar, double[] pVal) {
        super(dim, nPar, pVal);
        this.setTitle("PolynomialCoreNotNorm::P" + nPar);
        this.providesNormalization = false;
    }

    public PolynomialCoreNotNorm(String str) {
        super(1, PolynomialCoreNotNorm.getDimension(str));
        this.setTitle("PolynomialCoreNotNorm::" + str);
        this.providesNormalization = false;
    }

    public PolynomialCoreNotNorm(String str, double[] pVal) {
        super(1, PolynomialCoreNotNorm.getDimension(str), pVal);
        this.setTitle("PolynomialCoreNotNorm::" + str);
        this.providesNormalization = false;
    }

    @Override
    public double functionValue(double[] var) {
        double val = 0.0;
        for (int i = 1; i < this.numberOfParameters; ++i) {
            val += this.p[i] * Math.pow(var[0], i);
        }
        return val + this.p[0];
    }

    @Override
    public boolean providesGradient() {
        return true;
    }

    @Override
    public double[] gradient(double[] var) {
        double[] tmp = new double[]{0.0};
        if (this.numberOfParameters == 1) {
            return tmp;
        }
        double val = this.p[1];
        for (int i = 2; i < this.numberOfParameters; ++i) {
            val += (double)i * this.p[i] * Math.pow(var[0], i - 1);
        }
        tmp[0] = val;
        return tmp;
    }

    @Override
    public boolean providesParameterGradient() {
        return true;
    }

    @Override
    public double[] parameterGradient(double[] var) {
        double[] tmp = new double[this.numberOfParameters];
        tmp[0] = 1.0;
        for (int i = 1; i < this.numberOfParameters; ++i) {
            tmp[i] = Math.pow(var[0], i);
        }
        return tmp;
    }

    @Override
    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    @Override
    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        throw new UnsupportedOperationException(this.title() + " *****  Can not calculate normalization for a not normalized function");
    }

    public static int getDimension(String str) {
        if (!str.toLowerCase().startsWith("p")) {
            throw new IllegalArgumentException("Polynomial Function Qualifier must start with \"P\"");
        }
        return 1 + Integer.parseInt(str.substring(1));
    }

    @Override
    public Handle[] getHandles(double xLow, double xHigh, double yLow, double yHigh) {
        final double xmin = xLow;
        final double xmax = xHigh;
        double ymin = yLow;
        double ymax = yHigh;
        int order = this.numberOfParameters() - 1;
        Handle[] result = null;
        if (order == 0) {
            result = new Handle[]{new Handle(){

                public void moveTo(double x, double y) {
                    PolynomialCoreNotNorm.this.p[0] = y;
                    PolynomialCoreNotNorm.this.notifyCoreChanged();
                }

                public double getY() {
                    return PolynomialCoreNotNorm.this.p[0];
                }

                public double getX() {
                    return (xmax + xmin) / 2.0;
                }

                public Cursor cursor() {
                    return ImageHandler.getBestCursor((String)"resizeNSCursor.png", PolynomialCoreNotNorm.class, (int)0, (int)0);
                }
            }};
        } else if (order == 1) {
            double x1;
            result = new Handle[2];
            double x0 = (ymax - this.p[0]) / this.p[1];
            if (x0 < xmin) {
                x0 = xmin;
            }
            if (x0 > xmax) {
                x0 = xmax;
            }
            if ((x1 = (ymin - this.p[0]) / this.p[1]) < xmin) {
                x1 = xmin;
            }
            if (x1 > xmax) {
                x1 = xmax;
            }
            double xm = (x0 + x1) / 2.0;
            double ym = this.p[1] * xm + this.p[0];
            result[0] = new InPlotHandle(xmin, xmax, ymin, ymax){
                double tmpx;
                {
                    this.tmpx = Double.NaN;
                }

                public void moveTo(double x, double y) {
                    this.tmpx = x;
                    PolynomialCoreNotNorm.this.p[0] = y - PolynomialCoreNotNorm.this.p[1] * x;
                    if (!this.isInPlot(x, y)) {
                        this.tmpx = Double.NaN;
                    }
                    PolynomialCoreNotNorm.this.notifyCoreChanged();
                }

                public double getY() {
                    return PolynomialCoreNotNorm.this.p[1] * this.getX() + PolynomialCoreNotNorm.this.p[0];
                }

                public double getX() {
                    if (Double.isNaN(this.tmpx)) {
                        this.calculateIntersections();
                        this.tmpx = 0.8 * this.x0() + 0.2 * this.x1();
                    }
                    return this.tmpx;
                }

                public Cursor cursor() {
                    return ImageHandler.getBestCursor((String)"moveCursor.png", PolynomialCoreNotNorm.class, (int)0, (int)0);
                }
            };
            result[1] = new InPlotHandle(xmin, xmax, ymin, ymax){
                double tmpx;
                {
                    this.tmpx = Double.NaN;
                }

                public void moveTo(double x, double y) {
                    this.tmpx = x;
                    double yh = this.mirrorHandle().getY();
                    double xh = this.mirrorHandle().getX();
                    if (xh != x) {
                        PolynomialCoreNotNorm.this.p[1] = (yh - y) / (xh - x);
                    }
                    PolynomialCoreNotNorm.this.p[0] = y - PolynomialCoreNotNorm.this.p[1] * x;
                    if (!this.isInPlot(x, y)) {
                        this.tmpx = Double.NaN;
                    }
                    PolynomialCoreNotNorm.this.notifyCoreChanged();
                }

                public double getY() {
                    return PolynomialCoreNotNorm.this.p[1] * this.getX() + PolynomialCoreNotNorm.this.p[0];
                }

                public double getX() {
                    if (Double.isNaN(this.tmpx)) {
                        this.calculateIntersections();
                        this.tmpx = 0.2 * this.x0() + 0.8 * this.x1();
                    }
                    return this.tmpx;
                }

                public Cursor cursor() {
                    return ImageHandler.getBestCursor((String)"rotateCursor.png", PolynomialCoreNotNorm.class, (int)0, (int)0);
                }
            };
            ((MirrorHandle)result[1]).setMirrorHandle((MirrorHandle)result[0]);
        } else if (order == 2) {
            result = new Handle[]{new Handle(){

                public void moveTo(double x, double y) {
                    PolynomialCoreNotNorm.this.p[1] = -2.0 * PolynomialCoreNotNorm.this.p[2] * x;
                    PolynomialCoreNotNorm.this.p[0] = y - PolynomialCoreNotNorm.this.p[2] * x * x - PolynomialCoreNotNorm.this.p[1] * x;
                    PolynomialCoreNotNorm.this.notifyCoreChanged();
                }

                public double getX() {
                    return -PolynomialCoreNotNorm.this.p[1] / (2.0 * PolynomialCoreNotNorm.this.p[2]);
                }

                public double getY() {
                    ((PolynomialCoreNotNorm)PolynomialCoreNotNorm.this).tmpVar[0] = this.getX();
                    return PolynomialCoreNotNorm.this.functionValue(PolynomialCoreNotNorm.this.tmpVar);
                }

                public Cursor cursor() {
                    return ImageHandler.getBestCursor((String)"moveCursor.png", PolynomialCoreNotNorm.class, (int)0, (int)0);
                }
            }, new Handle(){

                public void moveTo(double x, double y) {
                    double xVertex;
                    ((PolynomialCoreNotNorm)PolynomialCoreNotNorm.this).tmpVar[0] = xVertex = -PolynomialCoreNotNorm.this.p[1] / (2.0 * PolynomialCoreNotNorm.this.p[2]);
                    double yVertex = PolynomialCoreNotNorm.this.functionValue(PolynomialCoreNotNorm.this.tmpVar);
                    PolynomialCoreNotNorm.this.p[2] = (y - yVertex) / Math.pow(x - xVertex, 2.0);
                    PolynomialCoreNotNorm.this.p[1] = -2.0 * PolynomialCoreNotNorm.this.p[2] * xVertex;
                    PolynomialCoreNotNorm.this.p[0] = y - PolynomialCoreNotNorm.this.p[2] * x * x - PolynomialCoreNotNorm.this.p[1] * x;
                    PolynomialCoreNotNorm.this.notifyCoreChanged();
                }

                public double getY() {
                    ((PolynomialCoreNotNorm)PolynomialCoreNotNorm.this).tmpVar[0] = this.getX();
                    return PolynomialCoreNotNorm.this.functionValue(PolynomialCoreNotNorm.this.tmpVar);
                }

                public double getX() {
                    double xVertex = -PolynomialCoreNotNorm.this.p[1] / (2.0 * PolynomialCoreNotNorm.this.p[2]);
                    double xMiddle = (xmax - xmin) / 2.0;
                    if (xVertex > xMiddle && xVertex < xmax) {
                        return (xVertex - xmin) / 2.0 + xmin;
                    }
                    if (xVertex <= xMiddle && xVertex > xmin) {
                        return xmax - (xmax - xVertex) / 2.0;
                    }
                    return xMiddle;
                }

                public Cursor cursor() {
                    return ImageHandler.getBestCursor((String)"resizeNSCursor.png", PolynomialCoreNotNorm.class, (int)0, (int)0);
                }
            }};
        }
        return result;
    }

    private abstract class InPlotHandle
    extends MirrorHandle {
        double x0;
        double y0;
        double x1;
        double y1;
        double xmin;
        double xmax;
        double ymin;
        double ymax;

        InPlotHandle(double xmin, double xmax, double ymin, double ymax) {
            this.xmin = xmin;
            this.xmax = xmax;
            this.ymin = ymin;
            this.ymax = ymax;
            this.calculateIntersections();
        }

        boolean isInPlot(double x, double y) {
            if (x > this.xmax || x < this.xmin) {
                return false;
            }
            return !(y > this.ymax) && !(y < this.ymin);
        }

        void calculateIntersections() {
            this.x0 = this.xmin;
            this.y0 = PolynomialCoreNotNorm.this.p[1] * this.x0 + PolynomialCoreNotNorm.this.p[0];
            if (this.y0 > this.ymax) {
                this.y0 = this.ymax;
            }
            if (this.y0 < this.ymin) {
                this.y0 = this.ymin;
            }
            if (PolynomialCoreNotNorm.this.p[1] != 0.0) {
                this.x0 = (this.y0 - PolynomialCoreNotNorm.this.p[0]) / PolynomialCoreNotNorm.this.p[1];
            }
            this.x1 = this.xmax;
            this.y1 = PolynomialCoreNotNorm.this.p[1] * this.x1 + PolynomialCoreNotNorm.this.p[0];
            if (this.y1 > this.ymax) {
                this.y1 = this.ymax;
            }
            if (this.y1 < this.ymin) {
                this.y1 = this.ymin;
            }
            if (PolynomialCoreNotNorm.this.p[1] != 0.0) {
                this.x1 = (this.y1 - PolynomialCoreNotNorm.this.p[0]) / PolynomialCoreNotNorm.this.p[1];
            }
        }

        double x0() {
            return this.x0;
        }

        double x1() {
            return this.x1;
        }

        double y0() {
            return this.y0;
        }

        double y1() {
            return this.y1;
        }
    }

    private abstract class MirrorHandle
    extends Handle {
        private MirrorHandle h = null;

        private MirrorHandle() {
        }

        void setMirrorHandle(MirrorHandle h) {
            this.h = h;
        }

        MirrorHandle mirrorHandle() {
            return this.h;
        }

        boolean hasMirrorHandle() {
            return this.h != null;
        }
    }
}

