/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.AbstractDevModelFunction;

public class ExponentModelFunction
extends AbstractDevModelFunction {
    public ExponentModelFunction(String str) {
        if (!str.toLowerCase().startsWith("e")) {
            throw new IllegalArgumentException("Exponent Function Qualifier must start with \"e\"");
        }
        int dim = Integer.parseInt(str.substring(1));
        this.setDimension(dim);
        this.setNumberOfParameters(dim + 1);
        this.setCodeletString("ExponentModelFunction");
        this.setNormalization(true, false);
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int numberOfParameters() {
        return this.p.length;
    }

    @Override
    public double functionValue(double[] var) {
        double val = 1.0;
        for (int i = 0; i < this.dimension; ++i) {
            val *= Math.exp(this.p[i] * var[i]);
        }
        return val * this.p[this.numberOfParameters() - 1];
    }
}

