/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Path
implements Serializable {
    private static final long serialVersionUID = -8411900835514833454L;
    private final Path parent;
    private final String name;
    public static final Path root = new Path();
    private int hash;
    private final int length;
    public static final LengthComparator LENGTH_COMPARATOR = new LengthComparator();

    public static Path path(Path parent, String path) {
        if (path == null) {
            throw new NullPointerException("The path parameter may not be null");
        }
        return Path.split(parent, path);
    }

    public static Path path(String path) {
        if (path == null || path.length() == 0) {
            return root;
        }
        return Path.split(null, path);
    }

    private static Path split(Path startFrom, String s) {
        Path parent = startFrom;
        StringBuilder sb = null;
        block3: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '/': {
                    if (sb == null) {
                        parent = root;
                        continue block3;
                    }
                    if (sb.length() > 0) {
                        String ss = sb.toString();
                        parent = parent != null ? parent.child(ss) : new Path(null, ss);
                    }
                    sb = null;
                    continue block3;
                }
                default: {
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append(c);
                }
            }
        }
        if (sb != null && sb.length() > 0) {
            String ss = sb.toString();
            parent = parent != null ? parent.child(ss) : new Path(null, ss);
        }
        return parent;
    }

    private Path() {
        this.parent = null;
        this.name = null;
        this.length = 0;
    }

    private Path(Path parent, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name may not be null");
        }
        this.parent = parent;
        this.name = name;
        this.length = this.parent != null ? this.parent.length + 1 : 1;
    }

    public int getLength() {
        return this.length;
    }

    public String[] getParts() {
        String[] arr = new String[this.length];
        Path p = this;
        int i = this.length;
        while (i > 0) {
            arr[--i] = p.getName();
            p = p.getParent();
        }
        return arr;
    }

    public String getFirst() {
        Path p = this;
        while (p.getParent() != null) {
            Path next = p.getParent();
            if (next.getName() == null) {
                return p.getName();
            }
            p = next;
        }
        if (p != null) {
            return p.getName();
        }
        return null;
    }

    public List<String> getAfterFirst() {
        ArrayList<String> afterFirst = new ArrayList<String>();
        Path p = this;
        while (p != null && p.getParent() != null && !p.getParent().isRoot()) {
            afterFirst.add(0, p.getName());
            if ((p = p.getParent()) != null) continue;
            break;
        }
        return afterFirst;
    }

    public Path getStripFirst() {
        return this.stripFirst(this);
    }

    Path stripFirst(Path p) {
        Path pParent = p.getParent();
        if (pParent == null || pParent.isRoot()) {
            return root;
        }
        pParent = this.stripFirst(pParent);
        return new Path(pParent, p.getName());
    }

    public String getName() {
        return this.name;
    }

    public Path getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null && this.name == null;
    }

    public String toPath() {
        if (this.isRoot()) {
            return "";
        }
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.toString() + '/' + this.name;
    }

    public String toString() {
        return this.toPath();
    }

    public String toString(String delimiter) {
        if (this.parent == null) {
            return "";
        }
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.toString(delimiter) + delimiter + this.name;
    }

    public static Path root() {
        return root;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.parent == null ? 158 : this.parent.hashCode() ^ this.name.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Path) {
            Path p2 = (Path)obj;
            if (this.isRoot()) {
                return p2.isRoot();
            }
            if (Path.parentEquals(this, p2)) {
                return this.name.equals(p2.name);
            }
            return false;
        }
        return false;
    }

    private static boolean parentEquals(Path p1, Path p2) {
        if (p2.parent == null) {
            return p1.parent == null;
        }
        return p2.parent.equals(p1.parent);
    }

    public Path child(String name) {
        Path ch = new Path(this, name);
        return ch;
    }

    public boolean isRelative() {
        if (this.parent == null) {
            return !this.isRoot();
        }
        return this.parent.isRelative();
    }

    public Path add(Path p) {
        Path x = this;
        for (String s : p.getParts()) {
            x = x.child(s);
        }
        return x;
    }

    public static class LengthComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path o1, Path o2) {
            Integer i1 = o1.getLength();
            Integer i2 = o2.getLength();
            return i1.compareTo(i2);
        }
    }
}

