/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.spring;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.dcache.auth.LoginStrategy;
import org.dcache.xrootd.door.LoginAuthenticationHandlerFactory;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthenticationProvider;
import org.dcache.xrootd.plugins.ChannelHandlerFactory;
import org.dcache.xrootd.plugins.authn.none.NoAuthenticationFactory;
import org.dcache.xrootd.spring.ChannelHandlerFactoryFactoryBean;
import org.springframework.beans.factory.annotation.Required;

public class GplazmaAwareChannelHandlerFactoryFactoryBean
extends ChannelHandlerFactoryFactoryBean {
    private static final ServiceLoader<AuthenticationProvider> _authenticationProviders = ServiceLoader.load(AuthenticationProvider.class);
    private static final String GPLAZMA_PREFIX = "gplazma:";
    private LoginStrategy _loginStrategy;
    private LoginStrategy _anonymousLoginStrategy;

    @Override
    @Required
    public void setPlugins(String plugins) {
        super.setPlugins(plugins);
        if (Iterables.any((Iterable)this._plugins, (Predicate)Predicates.containsPattern((String)"^authn:"))) {
            throw new IllegalArgumentException("The authn: prefix is not allowed in the xrootd door");
        }
        if (Iterables.size((Iterable)Iterables.filter((Iterable)this._plugins, (Predicate)Predicates.containsPattern((String)"^gplazma:"))) != 1) {
            throw new IllegalArgumentException("Exactly one authentication plugin is required");
        }
        int authn = Iterables.indexOf((Iterable)this._plugins, (Predicate)Predicates.containsPattern((String)"^gplazma:"));
        int authz = Iterables.indexOf((Iterable)this._plugins, (Predicate)Predicates.containsPattern((String)"^authz:"));
        if (authz > -1 && authz < authn) {
            throw new IllegalArgumentException("Authorization plugins must be placed after authentication plugins");
        }
    }

    @Required
    public void setLoginStrategy(LoginStrategy loginStrategy) {
        this._loginStrategy = loginStrategy;
    }

    @Required
    public void setAnonymousLoginStrategy(LoginStrategy anonymousLoginStrategy) {
        this._anonymousLoginStrategy = anonymousLoginStrategy;
    }

    @Override
    public List<ChannelHandlerFactory> getObject() throws Exception {
        ArrayList factories = Lists.newArrayList();
        for (String plugin : this._plugins) {
            if (plugin.startsWith(GPLAZMA_PREFIX)) {
                String name = plugin.substring(GPLAZMA_PREFIX.length());
                factories.add(this.createAuthenticationHandlerFactory(name));
                continue;
            }
            factories.add(this.createChannelHandlerFactory(plugin));
        }
        return factories;
    }

    private ChannelHandlerFactory createAuthenticationHandlerFactory(String name) throws Exception {
        if (name.equals("none")) {
            return new LoginAuthenticationHandlerFactory("gplazma:none", (AuthenticationFactory)new NoAuthenticationFactory(), this._anonymousLoginStrategy);
        }
        for (AuthenticationProvider provider : _authenticationProviders) {
            AuthenticationFactory factory = provider.createFactory(name, this._properties);
            if (factory == null) continue;
            return new LoginAuthenticationHandlerFactory(GPLAZMA_PREFIX + name, factory, this._loginStrategy);
        }
        throw new IllegalArgumentException("Authentication plugin not found: " + name);
    }
}

