/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.spring;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import dmg.cells.nucleus.EnvironmentAware;
import dmg.util.Formats;
import dmg.util.Replaceable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.dcache.xrootd.plugins.ChannelHandlerFactory;
import org.dcache.xrootd.plugins.ChannelHandlerProvider;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;

public class ChannelHandlerFactoryFactoryBean
implements FactoryBean<List<ChannelHandlerFactory>>,
EnvironmentAware {
    private static final ServiceLoader<ChannelHandlerProvider> _channelHandlerProviders = ServiceLoader.load(ChannelHandlerProvider.class);
    protected Iterable<String> _plugins;
    protected Properties _properties = new Properties();

    @Required
    public void setPlugins(String plugins) {
        this._plugins = Splitter.on((String)",").omitEmptyStrings().split((CharSequence)plugins);
    }

    public void setEnvironment(Map<String, Object> environment) {
        this._properties = ChannelHandlerFactoryFactoryBean.toProperties(environment);
    }

    public List<ChannelHandlerFactory> getObject() throws Exception {
        ArrayList factories = Lists.newArrayList();
        for (String plugin : this._plugins) {
            factories.add(this.createChannelHandlerFactory(plugin));
        }
        return factories;
    }

    public Class<List> getObjectType() {
        return List.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected ChannelHandlerFactory createChannelHandlerFactory(String plugin) throws Exception {
        for (ChannelHandlerProvider provider : _channelHandlerProviders) {
            ChannelHandlerFactory factory = provider.createFactory(plugin, this._properties);
            if (factory == null) continue;
            return factory;
        }
        throw new IllegalArgumentException("Channel handler plugin not found: " + plugin);
    }

    private static Properties toProperties(final Map<String, Object> env) {
        Replaceable replaceable = new Replaceable(){

            public String getReplacement(String name) {
                Object value = env.get(name);
                return value == null ? null : value.toString().trim();
            }
        };
        Properties properties = new Properties();
        for (Map.Entry<String, Object> e : env.entrySet()) {
            String key = e.getKey();
            String value = String.valueOf(e.getValue());
            properties.put(key, Formats.replaceKeywords((String)value, (Replaceable)replaceable));
        }
        return properties;
    }
}

