/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.pool;

import com.google.common.base.Strings;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.vehicles.PoolIoFileMessage;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.CompletionHandler;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.pool.FaultAction;
import org.dcache.pool.FaultEvent;
import org.dcache.pool.FaultListener;
import org.dcache.pool.classic.Cancellable;
import org.dcache.pool.classic.PostTransferService;
import org.dcache.pool.classic.TransferService;
import org.dcache.pool.movers.Mover;
import org.dcache.pool.movers.MoverChannel;
import org.dcache.pool.movers.MoverFactory;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.util.NetworkUtils;
import org.dcache.util.TryCatchTemplate;
import org.dcache.vehicles.XrootdDoorAdressInfoMessage;
import org.dcache.vehicles.XrootdProtocolInfo;
import org.dcache.xrootd.plugins.ChannelHandlerFactory;
import org.dcache.xrootd.pool.XrootdMover;
import org.dcache.xrootd.pool.XrootdPoolNettyServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class XrootdTransferService
extends AbstractCellComponent
implements MoverFactory,
TransferService<XrootdMover> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XrootdTransferService.class);
    private static final long CONNECT_TIMEOUT = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    private PostTransferService postTransferService;
    private FaultListener faultListener;
    private int diskThreads;
    private int maxMemoryPerConnection;
    private int maxMemory;
    private long clientIdleTimeout;
    private int maxFrameSize;
    private Integer socketThreads;
    private List<ChannelHandlerFactory> plugins;
    private XrootdPoolNettyServer server;

    @Required
    public void setPostTransferService(PostTransferService postTransferService) {
        this.postTransferService = postTransferService;
    }

    @Required
    public void setFaultListener(FaultListener faultListener) {
        this.faultListener = faultListener;
    }

    @Required
    public void setDiskThreads(int threads) {
        this.diskThreads = threads;
    }

    public int getDiskThreads() {
        return this.diskThreads;
    }

    @Required
    public void setMaxMemoryPerConnection(int bytes) {
        this.maxMemoryPerConnection = bytes;
    }

    public int getMaxMemoryPerConnection() {
        return this.maxMemoryPerConnection;
    }

    @Required
    public void setMaxMemory(int bytes) {
        this.maxMemory = bytes;
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    @Required
    public void setClientIdleTimeout(long clientIdleTimeout) {
        this.clientIdleTimeout = clientIdleTimeout;
    }

    public long getClientIdleTimeout() {
        return this.clientIdleTimeout;
    }

    public void setSocketThreads(String socketThreads) {
        this.socketThreads = Strings.isNullOrEmpty((String)socketThreads) ? null : Integer.valueOf(Integer.parseInt(socketThreads));
    }

    public String getSocketThreads() {
        return this.socketThreads == null ? null : String.valueOf(this.socketThreads);
    }

    @Required
    public void setPlugins(List<ChannelHandlerFactory> plugins) {
        this.plugins = plugins;
    }

    @Required
    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public List<ChannelHandlerFactory> getPlugins() {
        return this.plugins;
    }

    @PostConstruct
    public synchronized void init() {
        this.server = this.socketThreads == null ? new XrootdPoolNettyServer(this.diskThreads, this.maxMemoryPerConnection, this.maxMemory, this.clientIdleTimeout, this.maxFrameSize, this.plugins) : new XrootdPoolNettyServer(this.diskThreads, this.maxMemoryPerConnection, this.maxMemory, this.clientIdleTimeout, this.maxFrameSize, this.plugins, this.socketThreads);
    }

    @PreDestroy
    public synchronized void shutdown() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    public Mover<?> createMover(ReplicaDescriptor handle, PoolIoFileMessage message, CellPath pathToDoor) throws CacheException {
        return new XrootdMover(handle, message, pathToDoor, this, this.postTransferService);
    }

    public Cancellable execute(final XrootdMover mover, CompletionHandler<Void, Void> completionHandler) throws IOException, CacheException, NoRouteToCellException {
        return new TryCatchTemplate<Void, Void>(completionHandler){

            public void execute() throws IOException, CacheException, NoRouteToCellException {
                UUID uuid = ((XrootdProtocolInfo)mover.getProtocolInfo()).getUUID();
                MoverChannel channel = (MoverChannel)this.autoclose((Closeable)mover.open());
                this.setCancellable(XrootdTransferService.this.server.register(channel, uuid, CONNECT_TIMEOUT, (CompletionHandler)((Object)this)));
                XrootdTransferService.this.sendAddressToDoor(mover, XrootdTransferService.this.server.getServerAddress().getPort());
            }

            public void onFailure(Throwable t, Void attachment) throws CacheException {
                if (t instanceof DiskErrorCacheException) {
                    XrootdTransferService.this.faultListener.faultOccurred(new FaultEvent("repository", FaultAction.DISABLED, t.getMessage(), t));
                } else if (t instanceof NoRouteToCellException) {
                    throw new CacheException("Failed to send redirect message to door: " + t.getMessage(), t);
                }
            }
        };
    }

    private void sendAddressToDoor(XrootdMover mover, int port) throws SocketException, CacheException, NoRouteToCellException {
        XrootdProtocolInfo protocolInfo = (XrootdProtocolInfo)mover.getProtocolInfo();
        InetAddress localIP = NetworkUtils.getLocalAddress((InetAddress)protocolInfo.getSocketAddress().getAddress());
        CellPath cellpath = protocolInfo.getXrootdDoorCellPath();
        XrootdDoorAdressInfoMessage doorMsg = new XrootdDoorAdressInfoMessage(protocolInfo.getXrootdFileHandle(), new InetSocketAddress(localIP, port));
        this.sendMessage(new CellMessage(cellpath, (Serializable)((Object)doorMsg)));
        LOGGER.debug("sending redirect {} to Xrootd-door {}", (Object)localIP, (Object)cellpath);
    }
}

