/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.pool;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverChannel;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.vehicles.XrootdProtocolInfo;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdRequestHandler;
import org.dcache.xrootd.pool.ChunkedFileDescriptorReadResponse;
import org.dcache.xrootd.pool.ChunkedFileDescriptorReadvResponse;
import org.dcache.xrootd.pool.FileDescriptor;
import org.dcache.xrootd.pool.ReadDescriptor;
import org.dcache.xrootd.pool.WriteDescriptor;
import org.dcache.xrootd.pool.XrootdPoolNettyServer;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.CloseRequest;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.GenericReadRequestMessage;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.dcache.xrootd.protocol.messages.MkDirRequest;
import org.dcache.xrootd.protocol.messages.MvRequest;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.OpenResponse;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.ProtocolResponse;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.protocol.messages.RedirectResponse;
import org.dcache.xrootd.protocol.messages.RmDirRequest;
import org.dcache.xrootd.protocol.messages.RmRequest;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.protocol.messages.StatxRequest;
import org.dcache.xrootd.protocol.messages.SyncRequest;
import org.dcache.xrootd.protocol.messages.WriteRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.util.FileStatus;
import org.dcache.xrootd.util.OpaqueStringParser;
import org.dcache.xrootd.util.ParseException;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdPoolRequestHandler
extends XrootdRequestHandler {
    private static final Logger _log = LoggerFactory.getLogger(XrootdPoolRequestHandler.class);
    private static final int DEFAULT_FILESTATUS_ID = 0;
    private static final int DEFAULT_FILESTATUS_FLAGS = 0;
    private static final int DEFAULT_FILESTATUS_MODTIME = 0;
    private final List<FileDescriptor> _descriptors = new ArrayList<FileDescriptor>();
    private boolean _hasOpenedFiles;
    private InetSocketAddress _redirectingDoor;
    private XrootdPoolNettyServer _server;

    public XrootdPoolRequestHandler(XrootdPoolNettyServer server) {
        this._server = server;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws IOException {
        this._server.clientConnected();
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent event) {
        if (event.getState() == IdleState.ALL_IDLE && !this._hasOpenedFiles) {
            if (_log.isInfoEnabled()) {
                long idleTime = System.currentTimeMillis() - event.getLastActivityTimeMillis();
                _log.info("Closing idling connection without opened files. Connection has been idle for {} ms.", (Object)idleTime);
            }
            ctx.getChannel().close();
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent event) throws IOException {
        for (FileDescriptor descriptor : this._descriptors) {
            if (descriptor == null) continue;
            this._server.close(descriptor.getChannel());
        }
        this._server.clientDisconnected();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        Throwable t = e.getCause();
        if (t instanceof ClosedChannelException) {
            _log.info("Connection unexpectedly closed");
        } else if (t instanceof RuntimeException || t instanceof Error) {
            Thread me = Thread.currentThread();
            me.getUncaughtExceptionHandler().uncaughtException(me, t);
        } else {
            _log.warn(t.toString());
        }
    }

    protected AbstractResponseMessage doOnLogin(ChannelHandlerContext ctx, MessageEvent event, LoginRequest msg) {
        return this.withOk((XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnAuthentication(ChannelHandlerContext ctx, MessageEvent event, AuthenticationRequest msg) {
        return this.withOk((XrootdRequest)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractResponseMessage doOnOpen(ChannelHandlerContext ctx, MessageEvent event, OpenRequest msg) throws XrootdException {
        OpenResponse openResponse;
        block14: {
            UUID uuid;
            Map opaque;
            try {
                opaque = OpaqueStringParser.getOpaqueMap((String)msg.getOpaque());
            }
            catch (ParseException e) {
                _log.warn("Could not parse the opaque information in {}: {}", (Object)msg, (Object)e.getMessage());
                throw new XrootdException(3010, "Cannot parse opaque data: " + e.getMessage());
            }
            String uuidString = (String)opaque.get("org.dcache.uuid");
            if (uuidString == null) {
                _log.warn("Request contains no UUID: {}", (Object)msg);
                throw new XrootdException(3010, "org.dcache.uuid is missing. Contact redirector to obtain a new UUID.");
            }
            try {
                uuid = UUID.fromString(uuidString);
            }
            catch (IllegalArgumentException e) {
                _log.warn("Failed to parse UUID in {}: {}", (Object)msg, (Object)e.getMessage());
                throw new XrootdException(3010, "Cannot parse " + uuidString + ": " + e.getMessage());
            }
            MoverChannel file = this._server.open(uuid, false);
            if (file == null) {
                _log.warn("No mover found for {}", (Object)msg);
                throw new XrootdException(3010, "Request UUID is no longer valid. Contact redirector to obtain a new UUID.");
            }
            try {
                IoMode mode = file.getIoMode();
                if (msg.isNew() && mode != IoMode.WRITE) {
                    throw new XrootdException(3000, "File exists");
                }
                if (msg.isDelete() && mode != IoMode.WRITE) {
                    throw new XrootdException(3013, "File exists");
                }
                ReadDescriptor descriptor = (msg.isNew() || msg.isReadWrite()) && mode == IoMode.WRITE ? new WriteDescriptor((MoverChannel<XrootdProtocolInfo>)file) : new ReadDescriptor((MoverChannel<XrootdProtocolInfo>)file);
                FileStatus stat = msg.isRetStat() ? this.stat((RepositoryChannel)file) : null;
                int fd = this.getUnusedFileDescriptor();
                this._descriptors.set(fd, descriptor);
                this._redirectingDoor = ((XrootdProtocolInfo)file.getProtocolInfo()).getDoorAddress();
                file = null;
                this._hasOpenedFiles = true;
                openResponse = new OpenResponse((XrootdRequest)msg, (long)fd, null, null, stat);
                if (file == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        this._server.close(file);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new XrootdException(3007, e.getMessage());
                }
            }
            this._server.close(file);
        }
        return openResponse;
    }

    protected Object doOnStat(ChannelHandlerContext ctx, MessageEvent event, StatRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    protected Object doOnDirList(ChannelHandlerContext ctx, MessageEvent event, DirListRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    protected Object doOnMv(ChannelHandlerContext ctx, MessageEvent event, MvRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    protected Object doOnRm(ChannelHandlerContext ctx, MessageEvent event, RmRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    protected Object doOnRmDir(ChannelHandlerContext ctx, MessageEvent event, RmDirRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    protected Object doOnMkDir(ChannelHandlerContext ctx, MessageEvent event, MkDirRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    protected Object doOnStatx(ChannelHandlerContext ctx, MessageEvent event, StatxRequest msg) throws XrootdException {
        return this.redirectToDoor(ctx, event, (XrootdRequest)msg);
    }

    private Object redirectToDoor(ChannelHandlerContext ctx, MessageEvent event, XrootdRequest msg) throws XrootdException {
        if (this._redirectingDoor == null) {
            return this.unsupported(ctx, event, msg);
        }
        return new RedirectResponse(msg, this._redirectingDoor.getHostName(), this._redirectingDoor.getPort());
    }

    protected Object doOnRead(ChannelHandlerContext ctx, MessageEvent event, ReadRequest msg) throws XrootdException {
        int fd = msg.getFileHandle();
        if (!this.isValidFileDescriptor(fd)) {
            _log.error("Could not find a file descriptor for handle {}", (Object)fd);
            throw new XrootdException(3004, "The file handle does not refer to an open file.");
        }
        if (msg.bytesToRead() == 0) {
            return this.withOk((XrootdRequest)msg);
        }
        return new ChunkedFileDescriptorReadResponse(msg, this._server.getMaxFrameSize(), this._descriptors.get(fd));
    }

    protected Object doOnReadV(ChannelHandlerContext ctx, MessageEvent event, ReadVRequest msg) throws XrootdException {
        GenericReadRequestMessage.EmbeddedReadRequest[] list = msg.getReadRequestList();
        if (list == null || list.length == 0) {
            throw new XrootdException(3001, "Request contains no vector");
        }
        for (GenericReadRequestMessage.EmbeddedReadRequest req : list) {
            int fd = req.getFileHandle();
            if (!this.isValidFileDescriptor(fd)) {
                _log.error("Could not find file descriptor for handle {}!", (Object)fd);
                throw new XrootdException(3004, "Descriptor for the embedded read request does not refer to an open file.");
            }
            int totalBytesToRead = req.BytesToRead() + 16;
            if (totalBytesToRead <= this._server.getMaxFrameSize()) continue;
            _log.warn("Vector read of {} bytes requested, exceeds maximum frame size of {} bytes!", (Object)totalBytesToRead, (Object)this._server.getMaxFrameSize());
            throw new XrootdException(3000, "Single readv transfer is too large");
        }
        return new ChunkedFileDescriptorReadvResponse(msg, this._server.getMaxFrameSize(), new ArrayList<FileDescriptor>(this._descriptors));
    }

    protected AbstractResponseMessage doOnWrite(ChannelHandlerContext ctx, MessageEvent event, WriteRequest msg) throws XrootdException {
        int fd = msg.getFileHandle();
        if (!this.isValidFileDescriptor(fd)) {
            _log.info("No file descriptor for file handle {}", (Object)fd);
            throw new XrootdException(3004, "The file descriptor does not refer to an open file.");
        }
        FileDescriptor descriptor = this._descriptors.get(fd);
        if (!(descriptor instanceof WriteDescriptor)) {
            _log.info("File descriptor for handle {} is read-only, user tried to write.", (Object)fd);
            throw new XrootdException(3007, "Tried to write on read only file.");
        }
        try {
            descriptor.write(msg);
        }
        catch (ClosedChannelException e) {
            throw new XrootdException(3004, "The file was forcefully closed by the server");
        }
        catch (IOException e) {
            throw new XrootdException(3007, e.getMessage());
        }
        return this.withOk((XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnSync(ChannelHandlerContext ctx, MessageEvent event, SyncRequest msg) throws XrootdException {
        int fd = msg.getFileHandle();
        if (!this.isValidFileDescriptor(fd)) {
            _log.error("Could not find file descriptor for handle {}", (Object)fd);
            throw new XrootdException(3004, "The file descriptor does not refer to an open file.");
        }
        FileDescriptor descriptor = this._descriptors.get(fd);
        try {
            descriptor.sync(msg);
        }
        catch (ClosedChannelException e) {
            throw new XrootdException(3004, "The file was forcefully closed by the server");
        }
        catch (IOException e) {
            throw new XrootdException(3007, e.getMessage());
        }
        return this.withOk((XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnClose(ChannelHandlerContext ctx, MessageEvent event, CloseRequest msg) throws XrootdException {
        int fd = msg.getFileHandle();
        if (!this.isValidFileDescriptor(fd)) {
            _log.error("Could not find file descriptor for handle {}", (Object)fd);
            throw new XrootdException(3004, "The file descriptor does not refer to an open file.");
        }
        this._server.close(((FileDescriptor)this._descriptors.set(fd, null)).getChannel());
        return this.withOk((XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnProtocolRequest(ChannelHandlerContext ctx, MessageEvent event, ProtocolRequest msg) throws XrootdException {
        return new ProtocolResponse((XrootdRequest)msg, 1);
    }

    private int getUnusedFileDescriptor() {
        for (int i = 0; i < this._descriptors.size(); ++i) {
            if (this._descriptors.get(i) != null) continue;
            return i;
        }
        this._descriptors.add(null);
        return this._descriptors.size() - 1;
    }

    private boolean isValidFileDescriptor(int fd) {
        return fd >= 0 && fd < this._descriptors.size() && this._descriptors.get(fd) != null;
    }

    private FileStatus stat(RepositoryChannel file) throws IOException {
        return new FileStatus(0L, file.size(), 0, 0L);
    }
}

