/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.pool;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.dcache.pool.movers.AbstractNettyServer;
import org.dcache.util.PortRange;
import org.dcache.vehicles.XrootdProtocolInfo;
import org.dcache.xrootd.core.XrootdDecoder;
import org.dcache.xrootd.core.XrootdEncoder;
import org.dcache.xrootd.core.XrootdHandshakeHandler;
import org.dcache.xrootd.plugins.ChannelHandlerFactory;
import org.dcache.xrootd.pool.XrootdPoolRequestHandler;
import org.dcache.xrootd.stream.ChunkedResponseWriteHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.logging.LoggingHandler;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdPoolNettyServer
extends AbstractNettyServer<XrootdProtocolInfo> {
    private static final Logger _logger = LoggerFactory.getLogger(XrootdPoolNettyServer.class);
    private static final PortRange DEFAULT_PORTRANGE = new PortRange(20000, 25000);
    private final Timer _timer;
    private final long _clientIdleTimeout;
    private final int _maxFrameSize;
    private int _numberClientConnections;
    private List<ChannelHandlerFactory> _plugins;

    public XrootdPoolNettyServer(int threadPoolSize, int memoryPerConnection, int maxMemory, long clientIdleTimeout, int maxFrameSize, List<ChannelHandlerFactory> plugins) {
        this(threadPoolSize, memoryPerConnection, maxMemory, clientIdleTimeout, maxFrameSize, plugins, -1);
    }

    public XrootdPoolNettyServer(int threadPoolSize, int memoryPerConnection, int maxMemory, long clientIdleTimeout, int maxFrameSize, List<ChannelHandlerFactory> plugins, int socketThreads) {
        super("xrootd", threadPoolSize, memoryPerConnection, maxMemory, socketThreads);
        this._clientIdleTimeout = clientIdleTimeout;
        this._maxFrameSize = maxFrameSize;
        this._plugins = plugins;
        this._timer = new HashedWheelTimer();
        String range = System.getProperty("org.globus.tcp.port.range");
        PortRange portRange = range != null ? PortRange.valueOf((String)range) : DEFAULT_PORTRANGE;
        this.setPortRange(portRange);
    }

    public int getMaxFrameSize() {
        return this._maxFrameSize;
    }

    public void shutdown() {
        this.stopServer();
        this._timer.stop();
    }

    protected ChannelPipelineFactory newPipelineFactory() {
        return new XrootdPoolPipelineFactory();
    }

    protected synchronized void conditionallyStopServer() {
        if (this._numberClientConnections == 0) {
            super.conditionallyStopServer();
        }
    }

    public synchronized void clientConnected() {
        ++this._numberClientConnections;
    }

    public synchronized void clientDisconnected() {
        --this._numberClientConnections;
        this.conditionallyStopServer();
    }

    private class XrootdPoolPipelineFactory
    implements ChannelPipelineFactory {
        private XrootdPoolPipelineFactory() {
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("encoder", (ChannelHandler)new XrootdEncoder());
            pipeline.addLast("decoder", (ChannelHandler)new XrootdDecoder());
            if (_logger.isDebugEnabled()) {
                pipeline.addLast("logger", (ChannelHandler)new LoggingHandler(XrootdPoolNettyServer.class));
            }
            pipeline.addLast("handshake", (ChannelHandler)new XrootdHandshakeHandler(1));
            pipeline.addLast("executor", (ChannelHandler)new ExecutionHandler(XrootdPoolNettyServer.this.getDiskExecutor()));
            for (ChannelHandlerFactory plugin : XrootdPoolNettyServer.this._plugins) {
                pipeline.addLast("plugin:" + plugin.getName(), plugin.createHandler());
            }
            pipeline.addLast("timeout", (ChannelHandler)new IdleStateHandler(XrootdPoolNettyServer.this._timer, 0L, 0L, XrootdPoolNettyServer.this._clientIdleTimeout, TimeUnit.MILLISECONDS));
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedResponseWriteHandler());
            pipeline.addLast("transfer", (ChannelHandler)new XrootdPoolRequestHandler(XrootdPoolNettyServer.this));
            return pipeline;
        }
    }
}

