/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.pool;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.dcache.pool.movers.MoverChannel;
import org.dcache.vehicles.XrootdProtocolInfo;
import org.dcache.xrootd.pool.FileDescriptor;
import org.dcache.xrootd.protocol.messages.SyncRequest;
import org.dcache.xrootd.protocol.messages.WriteRequest;

public class ReadDescriptor
implements FileDescriptor {
    protected MoverChannel<XrootdProtocolInfo> _channel;

    public ReadDescriptor(MoverChannel<XrootdProtocolInfo> channel) {
        this._channel = channel;
    }

    @Override
    public void read(ByteBuffer buffer, long position) throws IOException {
        int bytes;
        while (buffer.hasRemaining() && (bytes = this._channel.read(buffer, position)) >= 0) {
            position += (long)bytes;
        }
    }

    @Override
    public void sync(SyncRequest msg) throws IOException {
    }

    @Override
    public void write(WriteRequest msg) throws IOException {
        throw new IOException("File is read only");
    }

    @Override
    public MoverChannel<XrootdProtocolInfo> getChannel() {
        return this._channel;
    }
}

