/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.pool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.pool.FileDescriptor;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.stream.AbstractChunkedReadvResponse;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class ChunkedFileDescriptorReadvResponse
extends AbstractChunkedReadvResponse {
    private final List<FileDescriptor> descriptors;

    public ChunkedFileDescriptorReadvResponse(ReadVRequest request, int maxFrameSize, List<FileDescriptor> descriptors) {
        super(request, maxFrameSize);
        this.descriptors = descriptors;
    }

    protected long getSize(int fd) throws IOException, XrootdException {
        if (fd < 0 || fd >= this.descriptors.size() || this.descriptors.get(fd) == null) {
            throw new XrootdException(3004, "Invalid file descriptor");
        }
        return this.descriptors.get(fd).getChannel().size();
    }

    protected ChannelBuffer read(int fd, long position, int length) throws IOException, XrootdException {
        if (fd < 0 || fd >= this.descriptors.size() || this.descriptors.get(fd) == null) {
            throw new XrootdException(3004, "Invalid file descriptor");
        }
        FileDescriptor descriptor = this.descriptors.get(fd);
        byte[] chunkArray = new byte[length];
        ByteBuffer chunk = ByteBuffer.wrap(chunkArray);
        descriptor.read(chunk, position);
        return ChannelBuffers.wrappedBuffer((byte[])chunkArray, (int)0, (int)(chunkArray.length - chunk.remaining()));
    }
}

