/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.door;

import diskCacheV111.util.FsPath;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.vehicles.ProtocolInfo;
import dmg.cells.nucleus.CellPath;
import java.net.InetSocketAddress;
import java.util.UUID;
import javax.security.auth.Subject;
import org.dcache.util.RedirectedTransfer;
import org.dcache.vehicles.XrootdProtocolInfo;

public class XrootdTransfer
extends RedirectedTransfer<InetSocketAddress> {
    private UUID _uuid;
    private InetSocketAddress _doorAddress;
    private int _fileHandle;

    public XrootdTransfer(PnfsHandler pnfs, Subject subject, FsPath path) {
        super(pnfs, subject, path);
    }

    public synchronized void setFileHandle(int fileHandle) {
        this._fileHandle = fileHandle;
    }

    public synchronized int getFileHandle() {
        return this._fileHandle;
    }

    public synchronized void setUUID(UUID uuid) {
        this._uuid = uuid;
    }

    public synchronized void setDoorAddress(InetSocketAddress doorAddress) {
        this._doorAddress = doorAddress;
    }

    protected synchronized ProtocolInfo createProtocolInfo() {
        InetSocketAddress client = this.getClientAddress();
        XrootdProtocolInfo protocolInfo = new XrootdProtocolInfo("Xrootd", 2, 7, client, new CellPath(this.getCellName(), this.getDomainName()), this.getPnfsId(), this._fileHandle, this._uuid, this._doorAddress);
        protocolInfo.setPath(this._path.toString());
        return protocolInfo;
    }

    protected ProtocolInfo getProtocolInfoForPoolManager() {
        return this.createProtocolInfo();
    }

    protected ProtocolInfo getProtocolInfoForPool() {
        return this.createProtocolInfo();
    }
}

