/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.door;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileExistsCacheException;
import diskCacheV111.util.FileIsNewCacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.NotFileCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.TimeoutCacheException;
import dmg.cells.nucleus.CellPath;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.dcache.auth.LoginReply;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.MessageCallback;
import org.dcache.util.list.DirectoryEntries;
import org.dcache.vehicles.PnfsListDirectoryMessage;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdRequestHandler;
import org.dcache.xrootd.door.LoginEvent;
import org.dcache.xrootd.door.XrootdDoor;
import org.dcache.xrootd.door.XrootdTransfer;
import org.dcache.xrootd.protocol.XrootdProtocol;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.DirListResponse;
import org.dcache.xrootd.protocol.messages.MkDirRequest;
import org.dcache.xrootd.protocol.messages.MvRequest;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.PrepareRequest;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.ProtocolResponse;
import org.dcache.xrootd.protocol.messages.RedirectResponse;
import org.dcache.xrootd.protocol.messages.RmDirRequest;
import org.dcache.xrootd.protocol.messages.RmRequest;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.protocol.messages.StatResponse;
import org.dcache.xrootd.protocol.messages.StatxRequest;
import org.dcache.xrootd.protocol.messages.StatxResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.util.OpaqueStringParser;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdRedirectHandler
extends XrootdRequestHandler {
    private static final Logger _log = LoggerFactory.getLogger(XrootdRedirectHandler.class);
    private final XrootdDoor _door;
    private boolean _isReadOnly = true;
    private FsPath _userRootPath = new FsPath();
    private final FsPath _rootPath;
    private final Set<Thread> _threads = Collections.synchronizedSet(new HashSet());

    public XrootdRedirectHandler(XrootdDoor door, FsPath rootPath) {
        this._door = door;
        this._rootPath = rootPath;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) throws Exception {
        if (event instanceof LoginEvent) {
            this.loggedIn((LoginEvent)event);
        }
        super.handleUpstream(ctx, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        Thread me = Thread.currentThread();
        this._threads.add(me);
        try {
            super.messageReceived(ctx, event);
        }
        finally {
            this._threads.remove(me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        Set<Thread> set = this._threads;
        synchronized (set) {
            for (Thread thread : this._threads) {
                thread.interrupt();
            }
        }
        super.channelDisconnected(ctx, event);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        Throwable t = event.getCause();
        if (t instanceof ClosedChannelException) {
            _log.info("Connection closed");
        } else if (t instanceof RuntimeException || t instanceof Error) {
            Thread me = Thread.currentThread();
            me.getUncaughtExceptionHandler().uncaughtException(me, t);
        } else {
            _log.warn(t.toString());
        }
    }

    protected AbstractResponseMessage doOnOpen(ChannelHandlerContext ctx, MessageEvent event, OpenRequest req) throws XrootdException {
        XrootdProtocol.FilePerm neededPerm;
        Channel channel = event.getChannel();
        InetSocketAddress localAddress = (InetSocketAddress)channel.getLocalAddress();
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.getRemoteAddress();
        int options = req.getOptions();
        if (req.isNew() || req.isReadWrite()) {
            if (this._isReadOnly) {
                throw new XrootdException(3010, "Read-only access");
            }
            neededPerm = XrootdProtocol.FilePerm.WRITE;
        } else {
            neededPerm = XrootdProtocol.FilePerm.READ;
        }
        _log.info("Opening {} for {}", (Object)req.getPath(), (Object)neededPerm.xmlText());
        if (_log.isDebugEnabled()) {
            this.logDebugOnOpen(req);
        }
        try {
            XrootdTransfer transfer;
            UUID uuid = UUID.randomUUID();
            String opaque = OpaqueStringParser.buildOpaqueString((String)"org.dcache.uuid", (String)uuid.toString());
            if (neededPerm == XrootdProtocol.FilePerm.WRITE) {
                boolean createDir = (options & 0x100) == 256;
                boolean overwrite = (options & 2) == 2;
                transfer = this._door.write(remoteAddress, this.createFullPath(req.getPath()), uuid, createDir, overwrite, localAddress, req.getSubject());
            } else {
                transfer = this._door.read(remoteAddress, this.createFullPath(req.getPath()), uuid, localAddress, req.getSubject());
            }
            InetSocketAddress address = (InetSocketAddress)transfer.getRedirect();
            _log.info("Redirecting to {}", (Object)address);
            return new RedirectResponse((XrootdRequest)req, address.getHostString(), address.getPort(), opaque, "");
        }
        catch (FileNotFoundCacheException e) {
            throw new XrootdException(3011, "No such file");
        }
        catch (FileExistsCacheException e) {
            throw new XrootdException(3013, "File already exists");
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (FileIsNewCacheException e) {
            throw new XrootdException(3003, "File is locked by upload");
        }
        catch (NotFileCacheException e) {
            throw new XrootdException(3015, "Not a file");
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to open file (%s [%d])", e.getMessage(), e.getRc()));
        }
        catch (InterruptedException e) {
            throw new XrootdException(3012, "Server shutdown");
        }
    }

    protected AbstractResponseMessage doOnStat(ChannelHandlerContext ctx, MessageEvent event, StatRequest req) throws XrootdException {
        String path = req.getPath();
        try {
            String client = ((InetSocketAddress)event.getChannel().getRemoteAddress()).getAddress().getHostAddress();
            return new StatResponse((XrootdRequest)req, this._door.getFileStatus(this.createFullPath(path), req.getSubject(), client));
        }
        catch (FileNotFoundCacheException e) {
            throw new XrootdException(3011, "No such file");
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to open file (%s [%d])", e.getMessage(), e.getRc()));
        }
    }

    protected AbstractResponseMessage doOnStatx(ChannelHandlerContext ctx, MessageEvent event, StatxRequest req) throws XrootdException {
        if (req.getPaths().length == 0) {
            throw new XrootdException(3001, "no paths specified");
        }
        try {
            FsPath[] paths = new FsPath[req.getPaths().length];
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = this.createFullPath(req.getPaths()[i]);
            }
            return new StatxResponse((XrootdRequest)req, this._door.getMultipleFileStatuses(paths, req.getSubject()));
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to open file (%s [%d])", e.getMessage(), e.getRc()));
        }
    }

    protected AbstractResponseMessage doOnRm(ChannelHandlerContext ctx, MessageEvent event, RmRequest req) throws XrootdException {
        if (req.getPath().isEmpty()) {
            throw new XrootdException(3001, "no path specified");
        }
        if (this._isReadOnly) {
            throw new XrootdException(3010, "Read-only access");
        }
        _log.info("Trying to delete {}", (Object)req.getPath());
        try {
            this._door.deleteFile(this.createFullPath(req.getPath()), req.getSubject());
            return this.withOk((XrootdRequest)req);
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (FileNotFoundCacheException e) {
            throw new XrootdException(3011, "No such file");
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to delete file (%s [%d])", e.getMessage(), e.getRc()));
        }
    }

    protected AbstractResponseMessage doOnRmDir(ChannelHandlerContext ctx, MessageEvent event, RmDirRequest req) throws XrootdException {
        if (req.getPath().isEmpty()) {
            throw new XrootdException(3001, "no path specified");
        }
        if (this._isReadOnly) {
            throw new XrootdException(3010, "Read-only access");
        }
        _log.info("Trying to delete directory {}", (Object)req.getPath());
        try {
            this._door.deleteDirectory(this.createFullPath(req.getPath()), req.getSubject());
            return this.withOk((XrootdRequest)req);
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (FileNotFoundCacheException e) {
            throw new XrootdException(3011, e.getMessage());
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to delete directory (%s [%d]).", e.getMessage(), e.getRc()));
        }
    }

    protected AbstractResponseMessage doOnMkDir(ChannelHandlerContext ctx, MessageEvent event, MkDirRequest req) throws XrootdException {
        if (req.getPath().isEmpty()) {
            throw new XrootdException(3001, "no path specified");
        }
        if (this._isReadOnly) {
            throw new XrootdException(3010, "Read-only access");
        }
        _log.info("Trying to create directory {}", (Object)req.getPath());
        try {
            this._door.createDirectory(this.createFullPath(req.getPath()), req.shouldMkPath(), req.getSubject());
            return this.withOk((XrootdRequest)req);
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (FileExistsCacheException | FileNotFoundCacheException e) {
            throw new XrootdException(3005, e.getMessage());
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to create directory (%s [%d]).", e.getMessage(), e.getRc()));
        }
    }

    protected AbstractResponseMessage doOnMv(ChannelHandlerContext ctx, MessageEvent event, MvRequest req) throws XrootdException {
        String sourcePath = req.getSourcePath();
        if (sourcePath.isEmpty()) {
            throw new XrootdException(3001, "no source path specified");
        }
        String targetPath = req.getTargetPath();
        if (targetPath.isEmpty()) {
            throw new XrootdException(3001, "no target path specified");
        }
        if (this._isReadOnly) {
            throw new XrootdException(3010, "Read-only access");
        }
        _log.info("Trying to rename {} to {}", (Object)req.getSourcePath(), (Object)req.getTargetPath());
        try {
            this._door.moveFile(this.createFullPath(req.getSourcePath()), this.createFullPath(req.getTargetPath()), req.getSubject());
            return this.withOk((XrootdRequest)req);
        }
        catch (TimeoutCacheException e) {
            throw new XrootdException(3012, "Internal timeout");
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
        catch (FileNotFoundCacheException e) {
            throw new XrootdException(3011, String.format("Source file does not exist (%s) ", e.getMessage()));
        }
        catch (FileExistsCacheException e) {
            throw new XrootdException(3005, String.format("Will not overwrite existing file (%s).", e.getMessage()));
        }
        catch (CacheException e) {
            throw new XrootdException(3012, String.format("Failed to move file (%s [%d]).", e.getMessage(), e.getRc()));
        }
    }

    protected AbstractResponseMessage doOnDirList(ChannelHandlerContext context, MessageEvent event, DirListRequest request) throws XrootdException {
        try {
            String listPath = request.getPath();
            if (listPath.isEmpty()) {
                throw new XrootdException(3001, "no source path specified");
            }
            _log.info("Listing directory {}", (Object)listPath);
            ListCallback callback = new ListCallback(request, context, event);
            this._door.listPath(this.createFullPath(listPath), request.getSubject(), (MessageCallback<PnfsListDirectoryMessage>)callback);
            return null;
        }
        catch (PermissionDeniedCacheException e) {
            throw new XrootdException(3010, e.getMessage());
        }
    }

    protected AbstractResponseMessage doOnPrepare(ChannelHandlerContext ctx, MessageEvent event, PrepareRequest msg) throws XrootdException {
        return this.withOk((XrootdRequest)msg);
    }

    protected AbstractResponseMessage doOnProtocolRequest(ChannelHandlerContext ctx, MessageEvent event, ProtocolRequest msg) throws XrootdException {
        return new ProtocolResponse((XrootdRequest)msg, 1);
    }

    private void logDebugOnOpen(OpenRequest req) {
        int options = req.getOptions();
        String openFlags = "options to apply for open path (raw=" + options + " ):";
        if ((options & 0x40) == 64) {
            openFlags = openFlags + " kXR_async";
        }
        if ((options & 1) == 1) {
            openFlags = openFlags + " kXR_compress";
        }
        if ((options & 2) == 2) {
            openFlags = openFlags + " kXR_delete";
        }
        if ((options & 4) == 4) {
            openFlags = openFlags + " kXR_force";
        }
        if ((options & 8) == 8) {
            openFlags = openFlags + " kXR_new";
        }
        if ((options & 0x10) == 16) {
            openFlags = openFlags + " kXR_open_read";
        }
        if ((options & 0x20) == 32) {
            openFlags = openFlags + " kXR_open_updt";
        }
        if ((options & 0x80) == 128) {
            openFlags = openFlags + " kXR_refresh";
        }
        if ((options & 0x100) == 256) {
            openFlags = openFlags + " kXR_mkpath";
        }
        if ((options & 0x200) == 512) {
            openFlags = openFlags + " kXR_open_apnd";
        }
        if ((options & 0x400) == 1024) {
            openFlags = openFlags + " kXR_retstat";
        }
        _log.debug("open flags: " + openFlags);
        int mode = req.getUMask();
        String s = "";
        s = (mode & 0x100) == 256 ? s + "r" : s + "-";
        s = (mode & 0x80) == 128 ? s + "w" : s + "-";
        s = (mode & 0x40) == 64 ? s + "x" : s + "-";
        s = s + " ";
        s = (mode & 0x20) == 32 ? s + "r" : s + "-";
        s = (mode & 0x10) == 16 ? s + "w" : s + "-";
        s = (mode & 8) == 8 ? s + "x" : s + "-";
        s = s + " ";
        s = (mode & 4) == 4 ? s + "r" : s + "-";
        s = (mode & 2) == 2 ? s + "w" : s + "-";
        s = (mode & 1) == 1 ? s + "x" : s + "-";
        _log.debug("mode to apply to open path: {}", (Object)s);
    }

    private void loggedIn(LoginEvent event) {
        LoginReply reply = event.getLoginReply();
        this._isReadOnly = false;
        this._userRootPath = new FsPath();
        if (reply != null) {
            for (LoginAttribute attribute : reply.getLoginAttributes()) {
                if (attribute instanceof ReadOnly) {
                    this._isReadOnly = ((ReadOnly)attribute).isReadOnly();
                    continue;
                }
                if (!(attribute instanceof RootDirectory)) continue;
                this._userRootPath = new FsPath(((RootDirectory)attribute).getRoot());
            }
        }
    }

    private FsPath createFullPath(String path) throws PermissionDeniedCacheException {
        FsPath fullPath = new FsPath(new FsPath[]{this._rootPath, new FsPath(path)});
        if (!fullPath.startsWith(this._userRootPath)) {
            throw new PermissionDeniedCacheException("Permission denied");
        }
        return fullPath;
    }

    private class ListCallback
    extends AbstractMessageCallback<PnfsListDirectoryMessage> {
        private final DirListRequest _request;
        private final ChannelHandlerContext _context;
        private final MessageEvent _event;

        public ListCallback(DirListRequest request, ChannelHandlerContext context, MessageEvent event) {
            this._request = request;
            this._context = context;
            this._event = event;
        }

        public void failure(int rc, Object error) {
            switch (rc) {
                case 10006: {
                    XrootdRedirectHandler.this.respond(this._context, this._event, XrootdRedirectHandler.this.withError((XrootdRequest)this._request, 3012, "Timeout when trying to list directory: " + error.toString()));
                    break;
                }
                case 10018: {
                    XrootdRedirectHandler.this.respond(this._context, this._event, XrootdRedirectHandler.this.withError((XrootdRequest)this._request, 3010, "Permission to list that directory denied: " + error.toString()));
                    break;
                }
                case 10001: {
                    XrootdRedirectHandler.this.respond(this._context, this._event, XrootdRedirectHandler.this.withError((XrootdRequest)this._request, 3011, "Path not found"));
                    break;
                }
                default: {
                    XrootdRedirectHandler.this.respond(this._context, this._event, XrootdRedirectHandler.this.withError((XrootdRequest)this._request, 3012, "Error when processing list response: " + error.toString()));
                }
            }
        }

        public void noroute(CellPath path) {
            XrootdRedirectHandler.this.respond(this._context, this._event, XrootdRedirectHandler.this.withError((XrootdRequest)this._request, 3012, "Could not contact PNFS Manager."));
        }

        public void success(PnfsListDirectoryMessage message) {
            Iterable directories = Iterables.transform((Iterable)message.getEntries(), (Function)DirectoryEntries.GET_NAME);
            if (message.isFinal()) {
                _log.debug("XrootdRedirectHandler: Received final listing message!");
                XrootdRedirectHandler.this.respond(this._context, this._event, new DirListResponse((XrootdRequest)this._request, directories));
            } else {
                XrootdRedirectHandler.this.respond(this._context, this._event, new DirListResponse((XrootdRequest)this._request, 4000, directories));
            }
        }

        public void timeout(CellPath path) {
            XrootdRedirectHandler.this.respond(this._context, this._event, XrootdRedirectHandler.this.withError((XrootdRequest)this._request, 3012, "Timeout when trying to list directory!"));
        }
    }
}

