/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.door;

import com.google.common.base.Splitter;
import com.google.common.collect.Ranges;
import diskCacheV111.movers.NetIFContainer;
import diskCacheV111.poolManager.PoolMonitorV5;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileLocality;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.IoDoorEntry;
import diskCacheV111.vehicles.IoDoorInfo;
import diskCacheV111.vehicles.PnfsMessage;
import diskCacheV111.vehicles.PoolIoFileMessage;
import diskCacheV111.vehicles.PoolMoverKillMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.LoginManagerChildrenInfo;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import org.dcache.acl.enums.AccessType;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.cells.MessageCallback;
import org.dcache.namespace.ACLPermissionHandler;
import org.dcache.namespace.ChainedPermissionHandler;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.namespace.PermissionHandler;
import org.dcache.namespace.PosixPermissionHandler;
import org.dcache.poolmanager.PoolMonitor;
import org.dcache.util.FireAndForgetTask;
import org.dcache.util.PingMoversTask;
import org.dcache.util.Transfer;
import org.dcache.util.TransferRetryPolicies;
import org.dcache.util.TransferRetryPolicy;
import org.dcache.vehicles.FileAttributes;
import org.dcache.vehicles.PnfsListDirectoryMessage;
import org.dcache.vehicles.XrootdDoorAdressInfoMessage;
import org.dcache.vehicles.XrootdProtocolInfo;
import org.dcache.xrootd.door.XrootdTransfer;
import org.dcache.xrootd.util.FileStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class XrootdDoor
extends AbstractCellComponent
implements CellMessageReceiver,
CellCommandListener {
    public static final String XROOTD_PROTOCOL_STRING = "Xrootd";
    public static final int XROOTD_PROTOCOL_MAJOR_VERSION = 2;
    public static final int XROOTD_PROTOCOL_MINOR_VERSION = 7;
    public static final String XROOTD_PROTOCOL_VERSION = String.format("%d.%d", 2, 7);
    private static final Logger _log = LoggerFactory.getLogger(XrootdDoor.class);
    private static final AtomicInteger _handleCounter = new AtomicInteger();
    private static final long PING_DELAY = 300000L;
    private static final TransferRetryPolicy RETRY_POLICY = TransferRetryPolicies.tryOncePolicy((long)Long.MAX_VALUE);
    private List<FsPath> _readPaths = Collections.singletonList(new FsPath());
    private List<FsPath> _writePaths = Collections.singletonList(new FsPath());
    private CellStub _poolStub;
    private CellStub _poolManagerStub;
    private CellStub _billingStub;
    private PoolMonitor _poolMonitor;
    private final PermissionHandler _pdp = new ChainedPermissionHandler(new PermissionHandler[]{new ACLPermissionHandler(), new PosixPermissionHandler()});
    private int _moverTimeout = 180000;
    private PnfsHandler _pnfs;
    private String _ioQueue;
    private Map<UUID, DirlistRequestHandler> _requestHandlers = new ConcurrentHashMap<UUID, DirlistRequestHandler>();
    private ScheduledExecutorService _dirlistTimeoutExecutor;
    private final Map<Integer, XrootdTransfer> _transfers = new ConcurrentHashMap<Integer, XrootdTransfer>();
    public static final String hh_get_children = "[-binary]";
    public static final String hh_get_door_info = "[-binary]";
    public static final String fh_get_door_info = "Provides information about the door and current transfers";
    public static final String hh_kill_mover = " <pool> <moverid> # kill transfer on the pool";

    @Required
    public void setPoolStub(CellStub stub) {
        this._poolStub = stub;
    }

    @Required
    public void setPoolManagerStub(CellStub stub) {
        this._poolManagerStub = stub;
    }

    @Required
    public void setBillingStub(CellStub stub) {
        this._billingStub = stub;
    }

    @Required
    public void setPoolMonitor(PoolMonitor poolMonitor) {
        this._poolMonitor = poolMonitor;
    }

    private List<FsPath> toFsPaths(String s) {
        ArrayList<FsPath> list = new ArrayList<FsPath>();
        for (String path : Splitter.on((String)":").omitEmptyStrings().split((CharSequence)s)) {
            list.add(new FsPath(path));
        }
        return list;
    }

    @Required
    public void setWritePaths(String s) {
        this._writePaths = this.toFsPaths(s);
    }

    @Required
    public List<FsPath> getWritePathsList() {
        return this._writePaths;
    }

    @Required
    public void setReadPaths(String s) {
        this._readPaths = this.toFsPaths(s);
    }

    public List<FsPath> getReadPathsList() {
        return this._readPaths;
    }

    @Required
    public void setPnfsHandler(PnfsHandler pnfs) {
        this._pnfs = pnfs;
    }

    @Required
    public void setIoQueue(String ioQueue) {
        this._ioQueue = ioQueue;
    }

    public String getIoQueue() {
        return this._ioQueue;
    }

    public int getMoverTimeout() {
        return this._moverTimeout;
    }

    @Required
    public void setMoverTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        this._moverTimeout = timeout;
    }

    @Required
    public void setExecutor(ScheduledExecutorService executor) {
        executor.scheduleAtFixedRate((Runnable)new FireAndForgetTask((Runnable)new PingMoversTask(this._transfers.values())), 300000L, 300000L, TimeUnit.MILLISECONDS);
    }

    @Required
    public void setDirlistTimeoutExecutor(ScheduledExecutorService executor) {
        this._dirlistTimeoutExecutor = executor;
    }

    public void getInfo(PrintWriter pw) {
        pw.println(String.format("Protocol Version %d.%d", 2, 7));
    }

    private XrootdTransfer createTransfer(InetSocketAddress client, FsPath path, UUID uuid, InetSocketAddress local, Subject subject) {
        XrootdTransfer transfer = new XrootdTransfer(this._pnfs, subject, path){

            public synchronized void finished(CacheException error) {
                super.finished(error);
                XrootdDoor.this._transfers.remove(this.getFileHandle());
                if (error == null) {
                    this.notifyBilling(0, "");
                    _log.info("Transfer {}@{} finished", (Object)this.getPnfsId(), (Object)this.getPool());
                } else {
                    int rc = error.getRc();
                    String message = error.getMessage();
                    this.notifyBilling(rc, message);
                    _log.info("Transfer {}@{} failed: {} (error code={})", new Object[]{this.getPnfsId(), this.getPool(), message, rc});
                }
            }
        };
        transfer.setCellName(this.getCellName());
        transfer.setDomainName(this.getCellDomainName());
        transfer.setPoolManagerStub(this._poolManagerStub);
        transfer.setPoolStub(this._poolStub);
        transfer.setBillingStub(this._billingStub);
        transfer.setClientAddress(client);
        transfer.setUUID(uuid);
        transfer.setDoorAddress(local);
        transfer.setFileHandle(_handleCounter.getAndIncrement());
        return transfer;
    }

    public XrootdTransfer read(InetSocketAddress client, FsPath path, UUID uuid, InetSocketAddress local, Subject subject) throws CacheException, InterruptedException {
        if (!this.isReadAllowed(path)) {
            throw new PermissionDeniedCacheException("Write permission denied");
        }
        XrootdTransfer transfer = this.createTransfer(client, path, uuid, local, subject);
        int handle = transfer.getFileHandle();
        InetSocketAddress address = null;
        this._transfers.put(handle, transfer);
        try {
            transfer.readNameSpaceEntry();
            transfer.selectPoolAndStartMover(this._ioQueue, RETRY_POLICY);
            address = (InetSocketAddress)transfer.waitForRedirect(this._moverTimeout);
            if (address == null) {
                throw new CacheException(transfer.getPool() + " failed to open TCP socket");
            }
            transfer.setStatus("Mover " + transfer.getPool() + "/" + transfer.getMoverId() + ": Sending");
        }
        catch (CacheException e) {
            transfer.notifyBilling(e.getRc(), e.getMessage());
            throw e;
        }
        catch (InterruptedException e) {
            transfer.notifyBilling(10011, "Transfer interrupted");
            throw e;
        }
        catch (RuntimeException e) {
            transfer.notifyBilling(10011, e.toString());
            throw e;
        }
        finally {
            if (address == null) {
                transfer.killMover(0L);
                this._transfers.remove(handle);
            }
        }
        return transfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XrootdTransfer write(InetSocketAddress client, FsPath path, UUID uuid, boolean createDir, boolean overwrite, InetSocketAddress local, Subject subject) throws CacheException, InterruptedException {
        if (!this.isWriteAllowed(path)) {
            throw new PermissionDeniedCacheException("Write permission denied");
        }
        XrootdTransfer transfer = this.createTransfer(client, path, uuid, local, subject);
        transfer.setOverwriteAllowed(overwrite);
        int handle = transfer.getFileHandle();
        InetSocketAddress address = null;
        this._transfers.put(handle, transfer);
        try {
            if (createDir) {
                transfer.createNameSpaceEntryWithParents();
            } else {
                transfer.createNameSpaceEntry();
            }
            try {
                transfer.selectPoolAndStartMover(this._ioQueue, RETRY_POLICY);
                address = (InetSocketAddress)transfer.waitForRedirect(this._moverTimeout);
                if (address == null) {
                    throw new CacheException(transfer.getPool() + " failed to open TCP socket");
                }
                transfer.setStatus("Mover " + transfer.getPool() + "/" + transfer.getMoverId() + ": Receiving");
            }
            finally {
                if (address == null) {
                    transfer.deleteNameSpaceEntry();
                }
            }
        }
        catch (CacheException e) {
            transfer.notifyBilling(e.getRc(), e.getMessage());
            throw e;
        }
        catch (InterruptedException e) {
            transfer.notifyBilling(10011, "Transfer interrupted");
            throw e;
        }
        catch (RuntimeException e) {
            transfer.notifyBilling(10011, e.toString());
            throw e;
        }
        finally {
            if (address == null) {
                this._transfers.remove(handle);
            }
        }
        return transfer;
    }

    public void deleteFile(FsPath path, Subject subject) throws PermissionDeniedCacheException, CacheException {
        PnfsHandler pnfsHandler = new PnfsHandler(this._pnfs, subject);
        if (!this.isWriteAllowed(path)) {
            throw new PermissionDeniedCacheException("Write permission denied");
        }
        EnumSet<FileType> allowedSet = EnumSet.of(FileType.REGULAR);
        pnfsHandler.deletePnfsEntry(path.toString(), allowedSet);
    }

    public void deleteDirectory(FsPath path, Subject subject) throws CacheException {
        PnfsHandler pnfsHandler = new PnfsHandler(this._pnfs, subject);
        if (!this.isWriteAllowed(path)) {
            throw new PermissionDeniedCacheException("Write permission denied");
        }
        EnumSet<FileType> allowedSet = EnumSet.of(FileType.DIR);
        pnfsHandler.deletePnfsEntry(path.toString(), allowedSet);
    }

    public void createDirectory(FsPath path, boolean createParents, Subject subject) throws CacheException {
        PnfsHandler pnfsHandler = new PnfsHandler(this._pnfs, subject);
        if (!this.isWriteAllowed(path)) {
            throw new PermissionDeniedCacheException("Write permission denied");
        }
        if (createParents) {
            pnfsHandler.createDirectories(path);
        } else {
            pnfsHandler.createPnfsDirectory(path.toString());
        }
    }

    public void moveFile(FsPath sourcePath, FsPath targetPath, Subject subject) throws CacheException {
        PnfsHandler pnfsHandler = new PnfsHandler(this._pnfs, subject);
        if (!this.isWriteAllowed(sourcePath)) {
            throw new PermissionDeniedCacheException("No write permission on source path!");
        }
        if (!this.isWriteAllowed(targetPath)) {
            throw new PermissionDeniedCacheException("No write permission on target path!");
        }
        pnfsHandler.renameEntry(sourcePath.toString(), targetPath.toString(), false);
    }

    public void listPath(FsPath path, Subject subject, MessageCallback<PnfsListDirectoryMessage> callback) {
        PnfsHandler pnfsHandler = new PnfsHandler(this._pnfs, subject);
        PnfsListDirectoryMessage msg = new PnfsListDirectoryMessage(path.toString(), null, Ranges.all(), EnumSet.noneOf(FileAttribute.class));
        UUID uuid = msg.getUUID();
        try {
            DirlistRequestHandler requestHandler = new DirlistRequestHandler(uuid, pnfsHandler.getPnfsTimeout(), callback);
            this._requestHandlers.put(uuid, requestHandler);
            pnfsHandler.send((PnfsMessage)msg);
            requestHandler.resetTimeout();
        }
        catch (NoRouteToCellException e) {
            this._requestHandlers.remove(uuid);
            callback.noroute(e.getDestinationPath());
        }
        catch (RejectedExecutionException ree) {
            this._requestHandlers.remove(uuid);
            callback.failure(10011, (Object)ree.getMessage());
        }
    }

    private boolean isWriteAllowed(FsPath path) {
        for (FsPath prefix : this._writePaths) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isReadAllowed(FsPath path) {
        for (FsPath prefix : this._readPaths) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private Inet4Address getFirstIpv4(Collection<NetIFContainer> interfaces) {
        for (NetIFContainer container : interfaces) {
            for (Object ip : container.getInetAddresses()) {
                if (!(ip instanceof Inet4Address)) continue;
                return (Inet4Address)ip;
            }
        }
        return null;
    }

    public void messageArrived(PoolIoFileMessage message) {
        String pool = message.getPoolName();
        int moverId = message.getMoverId();
        try {
            PoolMoverKillMessage killMessage = new PoolMoverKillMessage(pool, moverId);
            killMessage.setReplyRequired(false);
            this._poolStub.send(new CellPath(pool), (Serializable)killMessage);
        }
        catch (NoRouteToCellException e) {
            _log.error("Failed to kill mover {}/{}: {}", new Object[]{pool, moverId, e.getMessage()});
        }
    }

    public void messageArrived(XrootdDoorAdressInfoMessage msg) {
        _log.trace("Received redirect msg from mover");
        XrootdTransfer transfer = this._transfers.get(msg.getXrootdFileHandle());
        if (transfer != null) {
            transfer.redirect(msg.getSocketAddress());
        }
    }

    public void messageArrived(DoorTransferFinishedMessage msg) {
        if (msg.getProtocolInfo() instanceof XrootdProtocolInfo) {
            XrootdProtocolInfo info = (XrootdProtocolInfo)msg.getProtocolInfo();
            XrootdTransfer transfer = this._transfers.get(info.getXrootdFileHandle());
            if (transfer != null) {
                transfer.finished(msg);
            }
        } else {
            _log.warn("Ignoring unknown protocol info {} from pool {}", (Object)msg.getProtocolInfo(), (Object)msg.getPoolName());
        }
    }

    public void messageArrived(PnfsListDirectoryMessage msg) {
        UUID uuid = msg.getUUID();
        DirlistRequestHandler request = this._requestHandlers.get(uuid);
        if (request == null) {
            _log.info("Did not find the callback for directory listing message with UUID {}.", (Object)uuid);
            return;
        }
        if (msg.getReturnCode() == 0 && msg.isFinal()) {
            request.success(msg);
        } else if (msg.getReturnCode() == 0) {
            request.continueListing(msg);
        } else {
            request.failure(msg);
        }
    }

    private int getFileStatusFlags(Subject subject, FileAttributes attributes) {
        int flags = 0;
        switch (attributes.getFileType()) {
            case DIR: {
                boolean canListDir = this._pdp.canListDir(subject, attributes) == AccessType.ACCESS_ALLOWED;
                boolean canLookup = this._pdp.canLookup(subject, attributes) == AccessType.ACCESS_ALLOWED;
                boolean canCreateFile = this._pdp.canCreateFile(subject, attributes) == AccessType.ACCESS_ALLOWED;
                boolean canCreateDir = this._pdp.canCreateSubDir(subject, attributes) == AccessType.ACCESS_ALLOWED;
                flags |= 2;
                if (canLookup) {
                    flags |= 1;
                }
                if (canCreateFile || canCreateDir) {
                    flags |= 0x20;
                }
                if (!canListDir) break;
                flags |= 0x10;
                break;
            }
            case REGULAR: {
                boolean canWriteFile;
                boolean canReadFile = this._pdp.canReadFile(subject, attributes) == AccessType.ACCESS_ALLOWED;
                boolean bl = canWriteFile = this._pdp.canWriteFile(subject, attributes) == AccessType.ACCESS_ALLOWED;
                if (canWriteFile) {
                    flags |= 0x20;
                }
                if (canReadFile) {
                    flags |= 0x10;
                }
                if (!attributes.getStorageInfo().isCreatedOnly()) break;
                flags |= 0x40;
                break;
            }
            default: {
                flags |= 4;
            }
        }
        return flags;
    }

    public FileStatus getFileStatus(FsPath fullPath, Subject subject, String clientHost) throws CacheException {
        PnfsHandler pnfsHandler = new PnfsHandler(this._pnfs, subject);
        EnumSet<FileAttribute> requestedAttributes = EnumSet.of(FileAttribute.TYPE, FileAttribute.SIZE, FileAttribute.MODIFICATION_TIME, FileAttribute.STORAGEINFO);
        requestedAttributes.addAll(PoolMonitorV5.getRequiredAttributesForFileLocality());
        requestedAttributes.addAll(this._pdp.getRequiredAttributes());
        FileAttributes attributes = pnfsHandler.getFileAttributes(fullPath.toString(), requestedAttributes);
        int flags = this.getFileStatusFlags(subject, attributes);
        if (attributes.getFileType() != FileType.DIR) {
            FileLocality locality = this._poolMonitor.getFileLocality(attributes, clientHost);
            switch (locality) {
                case NEARLINE: 
                case LOST: 
                case UNAVAILABLE: {
                    flags |= 8;
                }
            }
        }
        return new FileStatus(0L, attributes.getSize(), flags, attributes.getModificationTime() / 1000L);
    }

    public int[] getMultipleFileStatuses(FsPath[] allPaths, Subject subject) throws CacheException {
        PnfsHandler pnfsHandler = new PnfsHandler(this._pnfs, subject);
        int[] flags = new int[allPaths.length];
        for (int i = 0; i < allPaths.length; ++i) {
            try {
                EnumSet<FileAttribute> requestedAttributes = EnumSet.of(FileAttribute.TYPE);
                requestedAttributes.addAll(this._pdp.getRequiredAttributes());
                FileAttributes attributes = pnfsHandler.getFileAttributes(allPaths[i].toString(), requestedAttributes);
                flags[i] = this.getFileStatusFlags(subject, attributes);
                continue;
            }
            catch (CacheException e) {
                if (e.getRc() != 10001 && e.getRc() != 10016) {
                    throw e;
                }
                flags[i] = 4;
            }
        }
        return flags;
    }

    public Object ac_get_children(Args args) {
        boolean binary = args.hasOption("binary");
        if (binary) {
            String[] list = new String[]{this.getCellName()};
            return new LoginManagerChildrenInfo(this.getCellName(), this.getCellDomainName(), list);
        }
        return this.getCellName();
    }

    public Object ac_get_door_info(Args args) {
        ArrayList<IoDoorEntry> entries = new ArrayList<IoDoorEntry>();
        for (Transfer transfer : this._transfers.values()) {
            entries.add(transfer.getIoDoorEntry());
        }
        IoDoorInfo doorInfo = new IoDoorInfo(this.getCellName(), this.getCellDomainName());
        doorInfo.setProtocol(XROOTD_PROTOCOL_STRING, XROOTD_PROTOCOL_VERSION);
        doorInfo.setOwner("");
        doorInfo.setProcess("");
        doorInfo.setIoDoorEntries(entries.toArray(new IoDoorEntry[entries.size()]));
        return args.hasOption("binary") ? doorInfo : doorInfo.toString();
    }

    public String ac_kill_mover_$_2(Args args) throws NumberFormatException {
        int mover = Integer.parseInt(args.argv(1));
        String pool = args.argv(0);
        for (Transfer transfer : this._transfers.values()) {
            if (transfer.getMoverId() != mover || transfer.getPool() == null || !transfer.getPool().equals(pool)) continue;
            transfer.killMover(0L);
            return "Kill request to the mover " + mover + " has been submitted";
        }
        return "mover " + mover + " not found on the pool " + pool;
    }

    private class DirlistRequestHandler {
        private ScheduledFuture<?> _executionInstance;
        private final long _timeout;
        private final UUID _uuid;
        private final MessageCallback<PnfsListDirectoryMessage> _callback;

        public DirlistRequestHandler(UUID uuid, long responseTimeout, MessageCallback<PnfsListDirectoryMessage> callback) {
            this._uuid = uuid;
            this._timeout = responseTimeout;
            this._callback = callback;
        }

        public synchronized void success(PnfsListDirectoryMessage msg) {
            if (XrootdDoor.this._requestHandlers.remove(this._uuid) == this) {
                this.cancelTimeout();
                this._callback.setReply((Object)msg);
                this._callback.success();
            }
        }

        public synchronized void continueListing(PnfsListDirectoryMessage msg) {
            this._callback.setReply((Object)msg);
            try {
                this._callback.success();
                this.resetTimeout();
            }
            catch (RejectedExecutionException ree) {
                XrootdDoor.this._requestHandlers.remove(this._uuid);
                this._callback.failure(10011, (Object)ree.getMessage());
            }
        }

        public synchronized void failure(PnfsListDirectoryMessage msg) {
            if (XrootdDoor.this._requestHandlers.remove(this._uuid) == this) {
                this.cancelTimeout();
                this._callback.setReply((Object)msg);
                this._callback.failure(msg.getReturnCode(), (Object)msg.getErrorObject());
            }
        }

        public synchronized void resetTimeout() throws RejectedExecutionException {
            Runnable target = new Runnable(){

                @Override
                public void run() {
                    if (XrootdDoor.this._requestHandlers.remove(DirlistRequestHandler.this._uuid) == DirlistRequestHandler.this) {
                        DirlistRequestHandler.this._callback.timeout(null);
                    }
                }
            };
            if (this._executionInstance != null) {
                this._executionInstance.cancel(false);
            }
            this._executionInstance = XrootdDoor.this._dirlistTimeoutExecutor.schedule(target, this._timeout, TimeUnit.MILLISECONDS);
        }

        public synchronized void cancelTimeout() {
            this._executionInstance.cancel(false);
        }
    }
}

