/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.door;

import dmg.cells.nucleus.CellInfo;
import dmg.util.Args;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellInfoProvider;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.SimpleChannelHandler;

@ChannelHandler.Sharable
public class ConnectionTracker
extends SimpleChannelHandler
implements CellCommandListener,
CellInfoProvider {
    private Map<Integer, Channel> _channels = new ConcurrentHashMap<Integer, Channel>();
    private AtomicInteger _counter = new AtomicInteger();

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelConnected(ctx, e);
        Channel channel = e.getChannel();
        this._channels.put(channel.getId(), channel);
        this._counter.getAndIncrement();
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this._channels.remove(e.getChannel().getId());
        super.channelDisconnected(ctx, e);
    }

    public CellInfo getCellInfo(CellInfo info) {
        return info;
    }

    public void getInfo(PrintWriter pw) {
        pw.println(String.format("Active : %d", this._channels.size()));
        pw.println(String.format("Created: %d", this._counter.get()));
    }

    public String ac_connections(Args args) {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<Integer, Channel> e : this._channels.entrySet()) {
            Channel c = e.getValue();
            s.append(e.getKey()).append(" ").append(c.getRemoteAddress()).append("\n");
        }
        return s.toString();
    }

    public String ac_kill_$_1(Args args) {
        int id = Integer.parseInt(args.argv(1));
        Channel channel = this._channels.get(id);
        if (channel == null) {
            return "No such connection";
        }
        Channels.close((Channel)channel);
        return "";
    }
}

