/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.vehicles;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.IpProtocolInfo;
import dmg.cells.nucleus.CellPath;
import java.net.InetSocketAddress;
import java.util.UUID;

public class XrootdProtocolInfo
implements IpProtocolInfo {
    private static final long serialVersionUID = -7070947404762513894L;
    private String _name;
    private int _minor;
    private int _major;
    @Deprecated
    private final String[] _hosts;
    @Deprecated
    private int _port;
    private InetSocketAddress _clientSocketAddress;
    private CellPath _pathToDoor;
    private PnfsId _pnfsId;
    private int _xrootdFileHandle;
    private String _path;
    private UUID _uuid;
    private InetSocketAddress _doorAddress;

    public XrootdProtocolInfo(String protocol, int major, int minor, InetSocketAddress clientAddress, CellPath pathToDoor, PnfsId pnfsID, int xrootdFileHandle, UUID uuid, InetSocketAddress doorAddress) {
        this._name = protocol;
        this._minor = minor;
        this._major = major;
        this._clientSocketAddress = clientAddress;
        this._hosts = new String[]{this._clientSocketAddress.getAddress().getHostAddress()};
        this._port = this._clientSocketAddress.getPort();
        this._pathToDoor = pathToDoor;
        this._pnfsId = pnfsID;
        this._xrootdFileHandle = xrootdFileHandle;
        this._uuid = uuid;
        this._doorAddress = doorAddress;
    }

    public String getProtocol() {
        return this._name;
    }

    public int getMinorVersion() {
        return this._minor;
    }

    public int getMajorVersion() {
        return this._major;
    }

    public String getVersionString() {
        return this._name + "-" + this._major + "." + this._minor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVersionString());
        sb.append(this._clientSocketAddress.getAddress().getHostAddress());
        sb.append(":").append(this._clientSocketAddress.getPort());
        return sb.toString();
    }

    public CellPath getXrootdDoorCellPath() {
        return this._pathToDoor;
    }

    public void setXrootdDoorCellPath(CellPath toDoor) {
        this._pathToDoor = toDoor;
    }

    public PnfsId getPnfsId() {
        return this._pnfsId;
    }

    public int getXrootdFileHandle() {
        return this._xrootdFileHandle;
    }

    public boolean isFileCheckRequired() {
        return false;
    }

    public UUID getUUID() {
        return this._uuid;
    }

    public InetSocketAddress getDoorAddress() {
        return this._doorAddress;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String getPath() {
        return this._path;
    }

    public InetSocketAddress getSocketAddress() {
        return this._clientSocketAddress;
    }
}

