/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.VOMSKeyManager;
import org.glite.voms.VOMSTrustManager;
import org.glite.voms.contact.UserCredentials;

public class VOMSSocket {
    private static final Logger log = Logger.getLogger(VOMSSocket.class);
    UserCredentials cred;
    String hostDN;
    private SSLContext context = null;
    private SSLSocket socket = null;

    public static VOMSSocket instance(UserCredentials userCredentials, String string, int n) {
        return new VOMSSocket(userCredentials, string, n);
    }

    public static VOMSSocket instance(UserCredentials userCredentials, String string) {
        return new VOMSSocket(userCredentials, string, 2);
    }

    private VOMSSocket(UserCredentials userCredentials, String string, int n) {
        this.cred = userCredentials;
        this.hostDN = string;
    }

    protected SSLSocketFactory getFactory() throws IOException, GeneralSecurityException {
        Object var1_1 = null;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        log.debug((Object)"Creating socket Factory");
        try {
            this.context = SSLContext.getInstance("SSLv3");
            log.debug((Object)("CONTEXT CREATED: " + this.context.getProtocol()));
            log.debug((Object)("Context: " + this.context));
            this.context.init(new VOMSKeyManager[]{new VOMSKeyManager(this.cred)}, new VOMSTrustManager[]{new VOMSTrustManager("")}, SecureRandom.getInstance("SHA1PRNG"));
            return this.context.getSocketFactory();
        }
        catch (SSLException sSLException) {
            log.fatal((Object)("Error opening SSL socket: " + sSLException.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)sSLException.getMessage(), (Throwable)sSLException);
            }
            throw sSLException;
        }
        catch (IOException iOException) {
            log.fatal((Object)("Error opening SSL socket: " + iOException.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)iOException.getMessage(), (Throwable)iOException);
            }
            throw iOException;
        }
    }

    protected void connect(String string, int n) throws IOException, GeneralSecurityException {
        SSLSocketFactory sSLSocketFactory = null;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        log.debug((Object)"Initting CONNECCTION");
        try {
            sSLSocketFactory = this.getFactory();
            log.debug((Object)"Factory Created");
            log.debug((Object)sSLSocketFactory.toString());
            log.debug((Object)"ABOUT to open CONNECTION");
            this.socket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
            log.debug((Object)"CONNECTION OPEN");
            String[] stringArray = new String[]{"SSLv3"};
            this.socket.setEnabledProtocols(stringArray);
        }
        catch (SSLException sSLException) {
            log.fatal((Object)("Error opening SSL socket: " + sSLException.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)sSLException.getMessage(), (Throwable)sSLException);
            }
            throw sSLException;
        }
        catch (IOException iOException) {
            log.fatal((Object)("Error opening SSL socket: " + iOException.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)iOException.getMessage(), (Throwable)iOException);
            }
            throw iOException;
        }
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public SSLContext getContext() {
        return this.context;
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            return this.socket.getOutputStream();
        }
        catch (IOException iOException) {
            log.error((Object)("Error getting output stream from underlying socket:" + iOException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
            throw iOException;
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.socket.getInputStream();
        }
        catch (IOException iOException) {
            log.error((Object)("Error getting input stream from underlying socket:" + iOException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
            throw iOException;
        }
    }
}

