/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import org.apache.log4j.Logger;
import org.glite.voms.contact.VOMSDecoder;
import org.glite.voms.contact.VOMSErrorMessage;
import org.glite.voms.contact.VOMSWarningMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VOMSResponse {
    private static int ERROR_OFFSET = 1000;
    private static final Logger log = Logger.getLogger(VOMSResponse.class);
    protected Document xmlResponse;

    public boolean hasErrors() {
        if (this.xmlResponse.getElementsByTagName("error").getLength() != 0) {
            return true;
        }
        return this.xmlResponse.getElementsByTagName("item").getLength() != 0 && this.xmlResponse.getElementsByTagName("ac").getLength() == 0;
    }

    public boolean hasWarnings() {
        if (this.xmlResponse.getElementsByTagName("warning").getLength() != 0) {
            return true;
        }
        return this.xmlResponse.getElementsByTagName("item").getLength() != 0 && this.xmlResponse.getElementsByTagName("ac").getLength() != 0;
    }

    public byte[] getAC() {
        Element element = (Element)this.xmlResponse.getElementsByTagName("ac").item(0);
        return VOMSDecoder.decode(element.getFirstChild().getNodeValue());
    }

    public byte[] getData() {
        Element element = (Element)this.xmlResponse.getElementsByTagName("bitstr").item(0);
        if (element != null) {
            return VOMSDecoder.decode(element.getFirstChild().getNodeValue());
        }
        return null;
    }

    public int getVersion() {
        Element element = (Element)this.xmlResponse.getElementsByTagName("version").item(0);
        if (element == null) {
            return 0;
        }
        return Integer.parseInt(element.getFirstChild().getNodeValue());
    }

    public String getACAsString() {
        Element element = (Element)this.xmlResponse.getElementsByTagName("ac").item(0);
        return element.getFirstChild().getNodeValue();
    }

    public VOMSErrorMessage[] errorMessages() {
        VOMSErrorMessage[] vOMSErrorMessageArray = this.errorMessagesREST();
        if (vOMSErrorMessageArray != null) {
            return vOMSErrorMessageArray;
        }
        NodeList nodeList = this.xmlResponse.getElementsByTagName("item");
        if (nodeList.getLength() == 0) {
            return null;
        }
        vOMSErrorMessageArray = new VOMSErrorMessage[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Element element2 = (Element)element.getElementsByTagName("number").item(0);
            Element element3 = (Element)element.getElementsByTagName("message").item(0);
            int n = Integer.parseInt(element2.getFirstChild().getNodeValue());
            if (n < ERROR_OFFSET) continue;
            vOMSErrorMessageArray[i] = new VOMSErrorMessage(n, element3.getFirstChild().getNodeValue());
        }
        return vOMSErrorMessageArray;
    }

    private VOMSErrorMessage[] errorMessagesREST() {
        NodeList nodeList = this.xmlResponse.getElementsByTagName("error");
        if (nodeList.getLength() == 0) {
            return null;
        }
        VOMSErrorMessage[] vOMSErrorMessageArray = new VOMSErrorMessage[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Element element2 = (Element)element.getElementsByTagName("code").item(0);
            Element element3 = (Element)element.getElementsByTagName("message").item(0);
            String string = element2.getFirstChild().getNodeValue();
            int n = string.equals("NoSuchUser") ? 1001 : (string.equals("BadRequest") ? 1005 : (string.equals("SuspendedUser") ? 1004 : 1006));
            vOMSErrorMessageArray[i] = new VOMSErrorMessage(n, element3.getFirstChild().getNodeValue());
        }
        return vOMSErrorMessageArray;
    }

    public VOMSWarningMessage[] warningMessages() {
        VOMSWarningMessage[] vOMSWarningMessageArray = this.warningMessagesREST();
        if (vOMSWarningMessageArray != null) {
            return vOMSWarningMessageArray;
        }
        NodeList nodeList = this.xmlResponse.getElementsByTagName("item");
        if (nodeList.getLength() == 0) {
            return null;
        }
        vOMSWarningMessageArray = new VOMSWarningMessage[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Element element2 = (Element)element.getElementsByTagName("number").item(0);
            Element element3 = (Element)element.getElementsByTagName("message").item(0);
            int n = Integer.parseInt(element2.getFirstChild().getNodeValue());
            if (n >= ERROR_OFFSET) continue;
            vOMSWarningMessageArray[i] = new VOMSWarningMessage(n, element3.getFirstChild().getNodeValue());
        }
        return vOMSWarningMessageArray;
    }

    private VOMSWarningMessage[] warningMessagesREST() {
        NodeList nodeList = this.xmlResponse.getElementsByTagName("warning");
        if (nodeList.getLength() == 0) {
            return null;
        }
        VOMSWarningMessage[] vOMSWarningMessageArray = new VOMSWarningMessage[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Element element2 = (Element)element.getElementsByTagName("message").item(0);
            String string = element.getFirstChild().getNodeValue();
            int n = string.contains("validity") ? 2 : (string.contains("selected") ? 1 : (string.contains("contains attributes") ? 3 : 4));
            log.debug((Object)("Message = " + string + " number = " + n));
            if (n >= ERROR_OFFSET) continue;
            vOMSWarningMessageArray[i] = new VOMSWarningMessage(n, string);
        }
        return vOMSWarningMessageArray;
    }

    public VOMSResponse(Document document) {
        this.xmlResponse = document;
    }
}

