/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class GenericAttribute
implements DEREncodable {
    private String name;
    private String value;
    private String qualifier;

    public GenericAttribute() {
        this.qualifier = null;
        this.value = null;
        this.name = null;
    }

    public GenericAttribute(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("Encoding error in GenericAttribute");
        }
        this.qualifier = null;
        this.value = null;
        this.name = null;
        if (!(aSN1Sequence.getObjectAt(0) instanceof ASN1OctetString && aSN1Sequence.getObjectAt(1) instanceof ASN1OctetString && aSN1Sequence.getObjectAt(2) instanceof ASN1OctetString)) {
            throw new IllegalArgumentException("Encoding error in GenericAttribute");
        }
        this.value = new String(DEROctetString.getInstance((Object)aSN1Sequence.getObjectAt(1)).getOctets());
        this.name = new String(DEROctetString.getInstance((Object)aSN1Sequence.getObjectAt(0)).getOctets());
        this.qualifier = new String(DEROctetString.getInstance((Object)aSN1Sequence.getObjectAt(2)).getOctets());
    }

    public static GenericAttribute getInstance(ASN1Sequence aSN1Sequence) {
        return new GenericAttribute(aSN1Sequence);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)new DEROctetString(this.name.getBytes()));
        aSN1EncodableVector.add((DEREncodable)new DEROctetString(this.value.getBytes()));
        aSN1EncodableVector.add((DEREncodable)new DEROctetString(this.qualifier.getBytes()));
        return new DERSequence((DEREncodableVector)aSN1EncodableVector);
    }
}

