/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.test.AidaTestCase;
import hep.aida.test.TestSuite;
import hep.aida.test.TestUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.textui.TestRunner;

public class AIDATestSuite {
    public static void main(String[] args) {
        int nRuns = 1;
        String[] files = null;
        if (args.length != 0) {
            if (args[0].equals("nRuns")) {
                if (args.length != 2) {
                    throw new RuntimeException("Need two arguments: nRuns followed by the number of times the tests have to be ran.");
                }
                nRuns = Integer.parseInt(args[1]);
            } else {
                files = args;
            }
        }
        if (nRuns <= 0) {
            throw new RuntimeException("Negative number of runs!! nRuns cannot be negative!!");
        }
        Vector errors = new Vector();
        Vector failures = new Vector();
        long startRun = System.currentTimeMillis();
        boolean printStat = false;
        int numberOfTests = 0;
        for (int k = 0; k < nRuns; ++k) {
            numberOfTests = 0;
            TestSuite testSuite = new TestSuite("AIDATestSuite");
            if (args.length == 0) {
                TestRunner.run((Test)testSuite.getSuite());
                continue;
            }
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    String fileName = files[i];
                    String testName = fileName.substring(0, fileName.indexOf("_"));
                    try {
                        BufferedReader in = new BufferedReader(new FileReader(fileName));
                        String seedS = in.readLine();
                        long seed = Long.parseLong(seedS);
                        AidaTestCase test = testSuite.getTest(testName);
                        test.setRandomSeed(seed);
                        TestRunner.run((Test)test);
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe.getMessage());
                    }
                }
                continue;
            }
            printStat = true;
            int run = k + 1;
            System.out.print(run + " ");
            for (int i = 0; i < testSuite.getSuite().testCount(); ++i) {
                junit.framework.TestSuite suite = (junit.framework.TestSuite)testSuite.getSuite().testAt(i);
                for (int j = 0; j < suite.testCount(); ++j) {
                    Enumeration e;
                    TestResult testResult = new TestResult();
                    AidaTestCase test = (AidaTestCase)suite.testAt(j);
                    ++numberOfTests;
                    test.run(testResult);
                    System.out.print(".");
                    if (testResult.errorCount() <= 0 && testResult.failureCount() <= 0) continue;
                    if (testResult.errorCount() > 0) {
                        e = testResult.errors();
                        while (e.hasMoreElements()) {
                            System.out.print("E");
                            errors.add(e.nextElement());
                        }
                    } else {
                        e = testResult.failures();
                        while (e.hasMoreElements()) {
                            System.out.print("F");
                            failures.add(e.nextElement());
                        }
                    }
                    test.saveRandomSeed();
                }
            }
            System.out.println();
        }
        if (printStat) {
            long endRun = System.currentTimeMillis();
            double totTime = (double)(endRun - startRun) / 1000.0;
            System.out.println("\nDone running.");
            System.out.println("Number of runs : " + nRuns + "  with " + numberOfTests + "  test per run");
            System.out.println("Total number of errors    : " + errors.size());
            System.out.println("Total numbero of failures : " + failures.size());
            System.out.println("Time                      : " + totTime + " sec.");
            if (errors.size() > 0) {
                System.out.println("\n**** Errors ****");
                for (int i = 0; i < errors.size(); ++i) {
                    System.out.println("--" + i + "--");
                    ((TestFailure)errors.get(i)).thrownException().printStackTrace(System.out);
                }
            }
            if (failures.size() > 0) {
                System.out.println("\n**** Failures ****");
                for (int i = 0; i < failures.size(); ++i) {
                    System.out.println("--" + i + "--");
                    ((TestFailure)failures.get(i)).thrownException().printStackTrace(System.out);
                }
            }
        }
    }

    public static File getTestFile(String fileName) throws IOException {
        String propertyDir = "hep.aida.test.data";
        String testDataDir = System.getProperty(propertyDir);
        if (testDataDir == null) {
            testDataDir = "/";
        }
        if (!testDataDir.endsWith("/")) {
            testDataDir = testDataDir + "/";
        }
        String testDataFile = System.getProperty(propertyDir + "." + fileName, testDataDir + fileName);
        String localRepository = System.getProperty("localRepository");
        if (localRepository != null) {
            testDataFile = TestUtils.replace("${localRepository}", localRepository, testDataFile);
        }
        File f = new File(testDataFile);
        return f;
    }
}

