/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class XrootdSecurityProtocol {
    public static final int kgST_error = -1;
    public static final int kgST_ok = 0;
    public static final int kgST_more = 1;
    public static final int kXGC_none = 0;
    public static final int kXGC_certreq = 1000;
    public static final int kXGC_cert = 1001;
    public static final int kXGC_sigpxy = 1002;
    public static final int kXGC_reserved = 1003;
    public static final int kXGS_none = 0;
    public static final int kXGS_init = 2000;
    public static final int kXGS_cert = 2001;
    public static final int kXGS_pxyreq = 2002;
    public static final int kXGS_reserved = 2003;
    public static final int kOptsDlgPxy = 1;
    public static final int kOptsFwdPxy = 2;
    public static final int kOptsSigReq = 4;
    public static final int kOptsSrvReq = 8;
    public static final int kOptsPxFile = 16;
    public static final int kOptsDelChn = 32;

    public static enum BucketType {
        kXRS_none(0),
        kXRS_inactive(1),
        kXRS_cryptomod(3000),
        kXRS_main(3001),
        kXRS_srv_seal(3002),
        kXRS_clnt_seal(3003),
        kXRS_puk(3004),
        kXRS_cipher(3005),
        kXRS_rtag(3006),
        kXRS_signed_rtag(3007),
        kXRS_user(3008),
        kXRS_host(3009),
        kXRS_creds(3010),
        kXRS_message(3011),
        kXRS_srvID(3012),
        kXRS_sessionID(3013),
        kXRS_version(3014),
        kXRS_status(3015),
        kXRS_localstatus(3016),
        kXRS_othercreds(3017),
        kXRS_cache_idx(3018),
        kXRS_clnt_opts(3019),
        kXRS_error_code(3020),
        kXRS_timestamp(3021),
        kXRS_x509(3022),
        kXRS_issuer_hash(3023),
        kXRS_x509_req(3024),
        kXRS_cipher_alg(3025),
        kXRS_md_alg(3026),
        kXRS_afsinfo(3027),
        kXRS_reserved(3028);

        private static final Map<Integer, BucketType> _lookup;
        private final int _code;

        private BucketType(int code) {
            this._code = code;
        }

        public int getCode() {
            return this._code;
        }

        public static BucketType get(int code) {
            return _lookup.get(code);
        }

        static {
            _lookup = new HashMap<Integer, BucketType>();
            for (BucketType s : EnumSet.allOf(BucketType.class)) {
                _lookup.put(s.getCode(), s);
            }
        }
    }
}

