/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectResponse
extends AbstractResponseMessage {
    private static final Logger _logger = LoggerFactory.getLogger(RedirectResponse.class);
    private final String _host;
    private final int _port;
    private final String _opaque;
    private final String _token;

    public RedirectResponse(XrootdRequest request, String host, int port) {
        this(request, host, port, "", "");
    }

    public RedirectResponse(XrootdRequest request, String host, int port, String opaque, String token) {
        super(request, 4004, 4 + host.length() + opaque.length() + token.length() + 2);
        this._host = host;
        this._port = port;
        this._opaque = opaque;
        this._token = token;
        this.putSignedInt(port);
        _logger.info("Sending the following host information to the client: {}", (Object)host);
        this.putCharSequence(host);
        if (!opaque.equals("")) {
            this.putCharSequence("?");
            this.putCharSequence(opaque);
        }
        if (!token.equals("")) {
            if (opaque.equals("")) {
                this.putCharSequence("?");
            }
            this.putCharSequence("?");
            this.putCharSequence(token);
        }
    }

    public String toString() {
        return String.format("redirect[%s:%d,%s,%s]", this._host, this._port, this._opaque, this._token);
    }
}

