/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import java.io.UnsupportedEncodingException;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.util.FileStatus;

public class OpenResponse
extends AbstractResponseMessage {
    private final long _fileHandle;
    private final Integer _cpsize;
    private final String _cptype;
    private final FileStatus _fs;

    public OpenResponse(XrootdRequest request, long fileHandle, Integer cpsize, String cptype, FileStatus fs) {
        super(request, 0, 256);
        this._fileHandle = fileHandle;
        this._cpsize = cpsize;
        this._cptype = cptype;
        this._fs = fs;
        try {
            this.putSignedInt((int)fileHandle);
            if (cpsize != null && cptype != null) {
                this.putSignedInt(cpsize);
                int len = Math.min(cptype.length(), 4);
                this._buffer.writeBytes(cptype.getBytes("ASCII"), 0, len);
                this._buffer.writeZero(4 - len);
            } else if (fs != null) {
                this._buffer.writeZero(8);
            }
            if (fs != null) {
                this.putCharSequence(fs.toString());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to construct xrootd message", e);
        }
    }

    public int getFileHandle() {
        return this._buffer.getInt(8);
    }

    public FileStatus getFileStatus() {
        return this._fs;
    }

    public String toString() {
        return String.format("open-response[%d,%d,%s,%s]", this._fileHandle, this._cpsize, this._cptype, this._fs);
    }
}

