/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import org.dcache.xrootd.protocol.messages.PathRequest;
import org.jboss.netty.buffer.ChannelBuffer;

public class OpenRequest
extends PathRequest {
    private final int _mode;
    private final int _options;

    public OpenRequest(ChannelBuffer buffer) {
        super(buffer, 3010);
        this._mode = buffer.getUnsignedShort(4);
        this._options = buffer.getUnsignedShort(6);
    }

    public int getUMask() {
        return this._mode;
    }

    public int getOptions() {
        return this._options;
    }

    public boolean isAsync() {
        return (this.getOptions() & 0x40) == 64;
    }

    public boolean isCompress() {
        return (this.getOptions() & 1) == 1;
    }

    public boolean isDelete() {
        return (this.getOptions() & 2) == 2;
    }

    public boolean isForce() {
        return (this.getOptions() & 4) == 4;
    }

    public boolean isNew() {
        return (this.getOptions() & 8) == 8;
    }

    public boolean isReadOnly() {
        return (this.getOptions() & 0x10) == 16;
    }

    public boolean isReadWrite() {
        return (this.getOptions() & 0x20) == 32;
    }

    public boolean isRefresh() {
        return (this.getOptions() & 0x80) == 128;
    }

    public boolean isRetStat() {
        return (this.getOptions() & 0x400) == 1024;
    }

    public boolean isMkPath() {
        return (this.getOptions() & 0x100) == 256;
    }

    public String toString() {
        return String.format("open[%d,%d,%s,%s]", this.getUMask(), this.getOptions(), this.getPath(), this.getOpaque());
    }
}

