/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponse
extends AbstractResponseMessage {
    private static final Logger _log = LoggerFactory.getLogger(ErrorResponse.class);
    private final int _errnum;
    private final String _errmsg;

    public ErrorResponse(XrootdRequest request, int errnum, String errmsg) {
        super(request, 4003, errmsg.length() + 4);
        this._errnum = errnum;
        this._errmsg = errmsg;
        this.putSignedInt(errnum);
        this.putCharSequence(errmsg);
        _log.info("Xrootd-Error-Response: ErrorNr=" + errnum + " ErrorMsg=" + errmsg);
    }

    public String toString() {
        return String.format("error[%d,%s]", this._errnum, this._errmsg);
    }
}

