/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import java.util.Properties;
import java.util.ServiceLoader;
import org.dcache.xrootd.core.XrootdAuthorizationHandlerFactory;
import org.dcache.xrootd.plugins.AuthorizationFactory;
import org.dcache.xrootd.plugins.AuthorizationProvider;
import org.dcache.xrootd.plugins.ChannelHandlerFactory;
import org.dcache.xrootd.plugins.ChannelHandlerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdAuthorizationHandlerProvider
implements ChannelHandlerProvider {
    private static final Logger _log = LoggerFactory.getLogger(XrootdAuthorizationHandlerProvider.class);
    static final String PREFIX = "authz:";
    private static ClassLoader _classLoader;

    public static void setPluginClassLoader(ClassLoader classLoader) {
        _classLoader = classLoader;
    }

    @Override
    public ChannelHandlerFactory createFactory(String plugin, Properties properties) throws Exception {
        if (plugin.startsWith(PREFIX)) {
            String name = plugin.substring(PREFIX.length());
            ServiceLoader<AuthorizationProvider> providers = _classLoader == null ? ServiceLoader.load(AuthorizationProvider.class) : ServiceLoader.load(AuthorizationProvider.class, _classLoader);
            for (AuthorizationProvider provider : providers) {
                AuthorizationFactory factory = provider.createFactory(name, properties);
                if (factory != null) {
                    _log.debug("AuthorizationHandler plugin {} is provided by {}", (Object)name, provider.getClass());
                    return new XrootdAuthorizationHandlerFactory(factory);
                }
                _log.debug("AuthorizationHandler plugin {} could not be provided by {}", (Object)name, provider.getClass());
            }
        }
        return null;
    }
}

