/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import java.util.Properties;
import java.util.ServiceLoader;
import org.dcache.xrootd.core.XrootdAuthenticationHandlerFactory;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthenticationProvider;
import org.dcache.xrootd.plugins.ChannelHandlerFactory;
import org.dcache.xrootd.plugins.ChannelHandlerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdAuthenticationHandlerProvider
implements ChannelHandlerProvider {
    private static final Logger _log = LoggerFactory.getLogger(XrootdAuthenticationHandlerProvider.class);
    static final String PREFIX = "authn:";
    private static ClassLoader _classLoader;

    public static void setPluginClassLoader(ClassLoader classLoader) {
        _classLoader = classLoader;
    }

    @Override
    public ChannelHandlerFactory createFactory(String plugin, Properties properties) throws Exception {
        if (plugin.startsWith(PREFIX)) {
            String name = plugin.substring(PREFIX.length());
            ServiceLoader<AuthenticationProvider> providers = _classLoader == null ? ServiceLoader.load(AuthenticationProvider.class) : ServiceLoader.load(AuthenticationProvider.class, _classLoader);
            for (AuthenticationProvider provider : providers) {
                AuthenticationFactory factory = provider.createFactory(name, properties);
                if (factory != null) {
                    _log.debug("AuthenticationHandler plugin {} is provided by {}", (Object)name, provider.getClass());
                    return new XrootdAuthenticationHandlerFactory(name, factory);
                }
                _log.debug("AuthenticationHandler plugin {} could not be provided by {}", (Object)name, provider.getClass());
            }
        }
        return null;
    }
}

