/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.security.Principal;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.GroupNamePrincipal;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.NoSuchPrincipalException;
import org.dcache.gplazma.plugins.GPlazmaIdentityPlugin;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.dcache.gplazma.plugins.GPlazmaSessionPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Nis
implements GPlazmaIdentityPlugin,
GPlazmaSessionPlugin,
GPlazmaMappingPlugin {
    private static final Logger _log = LoggerFactory.getLogger(Nis.class);
    private static final String GID_NUMBER_ATTRIBUTE = "gidNumber";
    private static final String HOME_DIR_ATTRIBUTE = "homeDirectory";
    private static final String UID_NUMBER_ATTRIBUTE = "uidNumber";
    private static final String COMMON_NAME_ATTRIBUTE = "cn";
    private static final String USER_ID_ATTRIBUTE = "uid";
    private static final String MEMBER_UID_ATTRIBUTE = "memberUid";
    private static final String NISMAP_GROUP_BY_GID = "system/group.bygid";
    private static final String NISMAP_PASSWORD_BY_NAME = "system/passwd.byname";
    private static final String NISMAP_GROUP_BY_NAME = "system/group.byname";
    private static final String NISMAP_PASSWORD_BY_UID = "system/passwd.byuid";
    private static final String SERVER = "gplazma.nis.server";
    private static final String DOMAIN = "gplazma.nis.domain";
    private final InitialDirContext _ctx;

    public Nis(Properties properties) throws NamingException {
        String server = properties.getProperty(SERVER);
        String domain = properties.getProperty(DOMAIN);
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.nis.NISCtxFactory");
        env.put("java.naming.provider.url", String.format("nis://%s/%s", server, domain));
        this._ctx = new InitialDirContext(env);
    }

    public void map(Set<Principal> principals) throws AuthenticationException {
        Principal principal = (Principal)Iterables.find(principals, (Predicate)Predicates.instanceOf(UserNamePrincipal.class), null);
        if (principal != null) {
            try {
                Attributes userAttr = this._ctx.getAttributes("system/passwd.byname/" + principal.getName());
                principals.add((Principal)new UidPrincipal((String)userAttr.get(UID_NUMBER_ATTRIBUTE).get()));
                principals.add((Principal)new GidPrincipal((String)userAttr.get(GID_NUMBER_ATTRIBUTE).get(), true));
                NamingEnumeration<SearchResult> groupResult = this._ctx.search(NISMAP_GROUP_BY_NAME, (Attributes)new BasicAttributes(MEMBER_UID_ATTRIBUTE, principal.getName()));
                while (groupResult.hasMore()) {
                    SearchResult result = groupResult.next();
                    principals.add((Principal)new GidPrincipal((String)result.getAttributes().get(GID_NUMBER_ATTRIBUTE).get(), false));
                }
            }
            catch (NamingException e) {
                _log.warn("Faild to get mapping: {}", (Object)e.toString());
                throw new AuthenticationException("no mapping: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public Principal map(Principal principal) throws NoSuchPrincipalException {
        String name = principal.getName();
        try {
            if (principal instanceof UserNamePrincipal) {
                Attributes userAttr = this._ctx.getAttributes("system/passwd.byname/" + name);
                return new UidPrincipal((String)userAttr.get(UID_NUMBER_ATTRIBUTE).get());
            }
            if (principal instanceof GroupNamePrincipal) {
                Attributes groupAttr = this._ctx.getAttributes("system/group.byname/" + name);
                return new GidPrincipal((String)groupAttr.get(GID_NUMBER_ATTRIBUTE).get(), false);
            }
        }
        catch (NamingException e) {
            _log.warn("Faild to get mapping: {}", (Object)e.toString());
        }
        throw new NoSuchPrincipalException(principal);
    }

    public Set<Principal> reverseMap(Principal principal) throws NoSuchPrincipalException {
        String id = principal.getName();
        try {
            HashSet<Principal> principals = new HashSet<Principal>();
            if (principal instanceof GidPrincipal) {
                NamingEnumeration<SearchResult> ne = this._ctx.search(NISMAP_GROUP_BY_GID, (Attributes)new BasicAttributes(GID_NUMBER_ATTRIBUTE, id));
                while (ne.hasMore()) {
                    SearchResult result = ne.next();
                    String name = (String)result.getAttributes().get(COMMON_NAME_ATTRIBUTE).get();
                    principals.add((Principal)new GroupNamePrincipal(name));
                }
            } else if (principal instanceof UidPrincipal) {
                NamingEnumeration<SearchResult> ne = this._ctx.search(NISMAP_PASSWORD_BY_UID, (Attributes)new BasicAttributes(UID_NUMBER_ATTRIBUTE, id));
                while (ne.hasMore()) {
                    SearchResult result = ne.next();
                    String name = (String)result.getAttributes().get(USER_ID_ATTRIBUTE).get();
                    principals.add((Principal)new UserNamePrincipal(name));
                }
            }
            return principals;
        }
        catch (NamingException e) {
            _log.warn("Faild to get reverse mapping: {}", (Object)e.toString());
            throw new NoSuchPrincipalException(principal);
        }
    }

    public void session(Set<Principal> authorizedPrincipals, Set<Object> attrib) throws AuthenticationException {
        Principal principal = (Principal)Iterables.find(authorizedPrincipals, (Predicate)Predicates.instanceOf(UserNamePrincipal.class), null);
        if (principal != null) {
            try {
                Attributes userAttr = this._ctx.getAttributes("system/passwd.byname/" + principal.getName());
                attrib.add(new HomeDirectory((String)userAttr.get(HOME_DIR_ATTRIBUTE).get()));
                attrib.add(new RootDirectory("/"));
                attrib.add(new ReadOnly(false));
            }
            catch (NamingException e) {
                throw new AuthenticationException("no mapping: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

