/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import java.io.PrintStream;
import org.rrd4j.core.jrrd.RRDFile;
import org.rrd4j.core.jrrd.UnivalArray;

public class CDPStatusBlock {
    final long offset;
    final long size;
    final int unknownDatapoints;
    final double value;
    final double secondary_value;
    final double primary_value;

    CDPStatusBlock(RRDFile file) throws IOException {
        this.offset = file.getFilePointer();
        UnivalArray scratch = file.getUnivalArray(10);
        this.value = scratch.getDouble(cdp_par_en.CDP_val);
        this.unknownDatapoints = (int)scratch.getDouble(cdp_par_en.CDP_unkn_pdp_cnt);
        this.primary_value = scratch.getDouble(cdp_par_en.CDP_primary_val);
        this.secondary_value = scratch.getDouble(cdp_par_en.CDP_secondary_val);
        this.size = file.getFilePointer() - this.offset;
    }

    public int getUnknownDatapoints() {
        return this.unknownDatapoints;
    }

    public double getValue() {
        return this.value;
    }

    void toXml(PrintStream s) {
        s.print("\t\t\t<ds><value> ");
        s.print(this.value);
        s.print(" </value>  <unknown_datapoints> ");
        s.print(this.unknownDatapoints);
        s.println(" </unknown_datapoints></ds>");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[CDPStatusBlock: OFFSET=0x");
        sb.append(Long.toHexString(this.offset));
        sb.append(", SIZE=0x");
        sb.append(Long.toHexString(this.size));
        sb.append(", unknownDatapoints=");
        sb.append(this.unknownDatapoints);
        sb.append(", value=");
        sb.append(this.value);
        sb.append(", primaryValue=");
        sb.append(this.primary_value);
        sb.append(", secondaryValue=");
        sb.append(this.secondary_value);
        sb.append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum cdp_par_en {
        CDP_val,
        CDP_unkn_pdp_cnt,
        CDP_hw_intercept,
        CDP_hw_last_intercept,
        CDP_hw_slope,
        CDP_hw_last_slope,
        CDP_null_count,
        CDP_last_null_count,
        CDP_primary_val,
        CDP_secondary_val;

    }
}

