/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.atomic.AtomicLong;
import org.rrd4j.core.RrdRandomAccessFileBackend;

public class RrdSafeFileBackend
extends RrdRandomAccessFileBackend {
    private static final Counters counters = new Counters();
    private FileLock lock;

    public RrdSafeFileBackend(String path, long lockWaitTime, long lockRetryPeriod) throws IOException {
        super(path, false);
        try {
            this.lockFile(lockWaitTime, lockRetryPeriod);
        }
        catch (IOException ioe) {
            super.close();
            throw ioe;
        }
    }

    private void lockFile(long lockWaitTime, long lockRetryPeriod) throws IOException {
        long entryTime = System.currentTimeMillis();
        FileChannel channel = this.rafile.getChannel();
        this.lock = channel.tryLock(0L, Long.MAX_VALUE, false);
        if (this.lock != null) {
            counters.registerQuickLock();
            return;
        }
        do {
            try {
                Thread.sleep(lockRetryPeriod);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.lock = channel.tryLock(0L, Long.MAX_VALUE, false);
            if (this.lock == null) continue;
            counters.registerDelayedLock();
            return;
        } while (System.currentTimeMillis() - entryTime <= lockWaitTime);
        counters.registerError();
        throw new IOException("Could not obtain exclusive lock on file: " + this.getPath() + "] after " + lockWaitTime + " milliseconds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.lock != null) {
                this.lock.release();
                this.lock = null;
                counters.registerUnlock();
            }
        }
        finally {
            super.close();
        }
    }

    protected boolean isCachingAllowed() {
        return false;
    }

    public static String getLockInfo() {
        return counters.getInfo();
    }

    static class Counters {
        final AtomicLong locks = new AtomicLong(0L);
        final AtomicLong quickLocks = new AtomicLong(0L);
        final AtomicLong unlocks = new AtomicLong(0L);
        final AtomicLong locked = new AtomicLong(0L);
        final AtomicLong errors = new AtomicLong(0L);

        Counters() {
        }

        void registerQuickLock() {
            this.locks.getAndIncrement();
            this.quickLocks.getAndIncrement();
            this.locked.getAndIncrement();
        }

        void registerDelayedLock() {
            this.locks.getAndIncrement();
            this.locked.getAndIncrement();
        }

        void registerUnlock() {
            this.unlocks.getAndIncrement();
            this.locked.getAndDecrement();
        }

        void registerError() {
            this.errors.getAndIncrement();
        }

        String getInfo() {
            return "LOCKS=" + this.locks + ", " + "UNLOCKS=" + this.unlocks + ", " + "DELAYED_LOCKS=" + (this.locks.get() - this.quickLocks.get()) + ", " + "LOCKED=" + this.locked + ", " + "ERRORS=" + this.errors;
        }
    }
}

