/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDbPool;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdFileBackendFactory;
import org.rrd4j.core.Util;

class RrdDbPoolOld
extends RrdDbPool {
    private int capacity = 200;
    private Map<String, RrdEntry> rrdMap = new HashMap<String, RrdEntry>(200);

    private RrdDbPoolOld() {
        if (!(RrdBackendFactory.getDefaultFactory() instanceof RrdFileBackendFactory)) {
            throw new RuntimeException("Cannot create instance of " + this.getClass().getName() + " with " + "a default backend factory not derived from RrdFileBackendFactory");
        }
    }

    public synchronized RrdDb requestRrdDb(String path) throws IOException {
        String canonicalPath = Util.getCanonicalPath(path);
        while (!this.rrdMap.containsKey(canonicalPath) && this.rrdMap.size() >= this.capacity) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.rrdMap.containsKey(canonicalPath)) {
            RrdEntry entry = this.rrdMap.get(canonicalPath);
            ++entry.count;
            return entry.rrdDb;
        }
        RrdDb rrdDb = new RrdDb(canonicalPath);
        this.rrdMap.put(canonicalPath, new RrdEntry(rrdDb));
        return rrdDb;
    }

    public synchronized RrdDb requestRrdDb(RrdDef rrdDef) throws IOException {
        String canonicalPath = Util.getCanonicalPath(rrdDef.getPath());
        while (this.rrdMap.containsKey(canonicalPath) || this.rrdMap.size() >= this.capacity) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        RrdDb rrdDb = new RrdDb(rrdDef);
        this.rrdMap.put(canonicalPath, new RrdEntry(rrdDb));
        return rrdDb;
    }

    public synchronized RrdDb requestRrdDb(String path, String sourcePath) throws IOException {
        String canonicalPath = Util.getCanonicalPath(path);
        while (this.rrdMap.containsKey(canonicalPath) || this.rrdMap.size() >= this.capacity) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        RrdDb rrdDb = new RrdDb(canonicalPath, sourcePath);
        this.rrdMap.put(canonicalPath, new RrdEntry(rrdDb));
        return rrdDb;
    }

    public synchronized void release(RrdDb rrdDb) throws IOException {
        if (rrdDb == null) {
            return;
        }
        String canonicalPath = Util.getCanonicalPath(rrdDb.getPath());
        if (!this.rrdMap.containsKey(canonicalPath)) {
            throw new IllegalStateException("Could not release [" + canonicalPath + "], the file was never requested");
        }
        RrdEntry entry = this.rrdMap.get(canonicalPath);
        if (--entry.count <= 0) {
            this.rrdMap.remove(canonicalPath);
            this.notifyAll();
            entry.rrdDb.close();
        }
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public synchronized String[] getOpenFiles() {
        return this.rrdMap.keySet().toArray(new String[this.rrdMap.keySet().size()]);
    }

    public synchronized int getOpenFileCount() {
        return this.rrdMap.size();
    }

    public synchronized int getOpenCount(RrdDb rrdDb) throws IOException {
        String canonicalPath = rrdDb.getCanonicalPath();
        RrdEntry ref = this.rrdMap.get(canonicalPath);
        if (ref == null) {
            return 0;
        }
        return ref.count;
    }

    public int getOpenCount(String path) throws IOException {
        String canonicalPath = Util.getCanonicalPath(path);
        RrdEntry ref = this.rrdMap.get(canonicalPath);
        if (ref == null) {
            return 0;
        }
        return ref.count;
    }

    class RrdEntry {
        RrdDb rrdDb;
        int count;

        RrdEntry(RrdDb rrdDb) {
            this.rrdDb = rrdDb;
            this.count = 1;
        }
    }
}

