/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.nis;

import com.sun.jndi.nis.Broadcaster;
import com.sun.jndi.nis.NISMap;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class NISDomainServerPair {
    public String domain;
    public String server;
    private Vector v = null;
    public static final String nisURLPrefix = "nis:";

    public NISDomainServerPair(String string, String string2) {
        this.domain = string;
        this.server = string2;
    }

    public void addServer(String string) {
        if (this.v == null) {
            this.v = new Vector();
            this.v.addElement(this.server);
        }
        this.v.addElement(string);
    }

    public static String broadcastForServer(String string) {
        return NISDomainServerPair.broadcastForServer(string, 1000);
    }

    public static String broadcastForServer(String string, int n) {
        try {
            Broadcaster broadcaster = new Broadcaster(string);
            Thread thread = NISMap.helper.createThread(broadcaster);
            thread.start();
            thread.join(n);
            thread.stop();
            String string2 = broadcaster.getServer();
            return string2;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public Enumeration getServers() {
        if (this.v != null) {
            return this.v.elements();
        }
        return new SingleEnum();
    }

    public static NISDomainServerPair parseURL(String string) {
        if (!string.startsWith(nisURLPrefix)) {
            return null;
        }
        String string2 = string.substring(nisURLPrefix.length());
        int n = 0;
        String string3 = null;
        String string4 = null;
        if (string2.startsWith("//")) {
            int n2 = string2.indexOf(47, n += 2);
            if (n2 > n) {
                string4 = string2.substring(n, n2++);
            } else if (n2 == n) {
                n2 = n + 1;
            } else {
                return null;
            }
            if (n2 < string2.length()) {
                string3 = string2.substring(n2);
            }
        } else if (string2.startsWith("/")) {
            if (string2.length() > 1) {
                string3 = string2.substring(1);
            }
        } else if (string2.length() > 0) {
            string3 = string2;
        }
        if (string3 != null) {
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            return new NISDomainServerPair(string3, string4);
        }
        return null;
    }

    class SingleEnum
    implements Enumeration {
        boolean more = true;

        SingleEnum() {
        }

        public boolean hasMoreElements() {
            return this.more;
        }

        public Object nextElement() {
            if (this.more) {
                this.more = false;
                return NISDomainServerPair.this.server;
            }
            throw new NoSuchElementException();
        }
    }
}

