/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.nis;

import com.sun.jndi.nis.KeyValuePair;
import com.sun.jndi.nis.NISCtx;
import com.sun.jndi.nis.NISMap;
import com.sun.jndi.nis.NISObject;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.spi.DirectoryManager;

class NISCtxRpc
extends NISCtx {
    private static final String[] rpcAttrIds = new String[]{"cn", "oncRpcNumber", "description"};
    static /* synthetic */ Class class$com$sun$jndi$nis$NISObject;

    NISCtxRpc() {
        this.objectclass.add("oncRpc");
    }

    protected Attributes c_getAttributes(Name name, String[] stringArray, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return this.getMapAttributes(stringArray);
        }
        NISMap nISMap = this.getNISMap();
        String string = name.toString();
        String string2 = this.findEntry(nISMap.getAllEntries(), string);
        if (string2 == null) {
            NameNotFoundException nameNotFoundException = new NameNotFoundException();
            throw continuation.fillInException(nameNotFoundException);
        }
        Attributes attributes = this.getAttributesFromEntry(string, string2, stringArray);
        continuation.setSuccess();
        return attributes;
    }

    protected Object c_lookup(Name name, Continuation continuation) throws NamingException {
        if (name.isEmpty()) {
            continuation.setSuccess();
            return this;
        }
        NISMap nISMap = this.getNISMap();
        String string = name.toString();
        String string2 = this.findEntry(nISMap.getAllEntries(), string);
        if (string2 != null) {
            continuation.setSuccess();
            NISObject nISObject = new NISObject(this, string, string2, this.environment);
            try {
                Attributes attributes = this.getAttributesFromEntry(string, string2, null);
                return DirectoryManager.getObjectInstance(nISObject, name, this, this.environment, attributes);
            }
            catch (NamingException namingException) {
                throw continuation.fillInException(namingException);
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("problem generating object using object factory");
                namingException.setRootCause(exception);
                throw continuation.fillInException(namingException);
            }
        }
        NameNotFoundException nameNotFoundException = new NameNotFoundException();
        throw continuation.fillInException(nameNotFoundException);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected String findEntry(NamingEnumeration namingEnumeration, String string) throws NamingException {
        while (namingEnumeration.hasMore()) {
            KeyValuePair keyValuePair = (KeyValuePair)namingEnumeration.next();
            String string2 = keyValuePair.getValue();
            String string3 = this.getName(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public Attributes getAttributesFromEntry(String string, String string2, String[] stringArray) throws NamingException {
        String string3;
        boolean bl;
        BasicAttributes basicAttributes = new BasicAttributes(true);
        boolean bl2 = bl = stringArray == null;
        if (!bl && stringArray.length == 0) {
            return basicAttributes;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        BasicAttribute basicAttribute = new BasicAttribute(rpcAttrIds[0]);
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            basicAttribute.add(string3);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (bl || NISCtx.findId(stringArray, rpcAttrIds[1]) >= 0) {
                basicAttributes.put(rpcAttrIds[1], string3);
            }
        }
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.charAt(0) == '#') {
                if (!bl && NISCtx.findId(stringArray, rpcAttrIds[2]) < 0 || !stringTokenizer.hasMoreTokens() || (string3 = stringTokenizer.nextToken("\n").trim()).length() <= 0) break;
                basicAttributes.put(rpcAttrIds[2], string3);
                break;
            }
            basicAttribute.add(string3);
        }
        if (basicAttribute.size() > 0 && (bl || NISCtx.findId(stringArray, rpcAttrIds[0]) >= 0)) {
            basicAttributes.put(basicAttribute);
        }
        if (bl || NISCtx.findId(stringArray, "nisMapEntry") >= 0) {
            basicAttributes.put("nisMapEntry", string2);
        }
        if (bl || NISCtx.findId(stringArray, "nisMapName") >= 0) {
            basicAttributes.put("nisMapName", this.realMapname);
        }
        if (bl || NISCtx.findId(stringArray, "objectClass") >= 0) {
            basicAttributes.put(this.objectclass);
        }
        return basicAttributes;
    }

    protected NamingEnumeration getBindingList(NamingEnumeration namingEnumeration, boolean bl) {
        return new NISBindingList(namingEnumeration, bl);
    }

    protected String[] getIDs() {
        return rpcAttrIds;
    }

    protected String getName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        return stringTokenizer.nextToken();
    }

    protected NamingEnumeration getNameClassList(NamingEnumeration namingEnumeration) {
        return new NISNCList(namingEnumeration);
    }

    protected String getNameFromEntry(String string, Attributes attributes) throws NamingException {
        Attribute attribute = attributes.get("cn");
        if (attribute == null) {
            throw new ConfigurationException("an rpc.bynumber entry must have a name");
        }
        return (String)attribute.get();
    }

    protected Attribute getPrimaryAttribute(Attributes attributes) {
        if (attributes != null) {
            return attributes.get(rpcAttrIds[1]);
        }
        return null;
    }

    protected void initMapname(String string) {
        this.realMapname = "rpc.bynumber";
        this.mapname = "rpc.bynumber";
    }

    class NISNCList
    implements NamingEnumeration {
        NamingEnumeration keyvalues;

        NISNCList(NamingEnumeration namingEnumeration) {
            this.keyvalues = namingEnumeration;
        }

        public void close() {
            this.keyvalues = null;
        }

        public boolean hasMore() throws NamingException {
            return this.keyvalues.hasMore();
        }

        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException namingException) {
                return false;
            }
        }

        public Object next() throws NamingException {
            KeyValuePair keyValuePair = (KeyValuePair)this.keyvalues.next();
            String string = (class$com$sun$jndi$nis$NISObject != null ? class$com$sun$jndi$nis$NISObject : (class$com$sun$jndi$nis$NISObject = NISCtxRpc.class$("com.sun.jndi.nis.NISObject"))).getName();
            String string2 = keyValuePair.getValue();
            String string3 = NISCtxRpc.this.getName(string2);
            return new NameClassPair(string3, string);
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException();
            }
        }
    }

    class NISBindingList
    extends NISNCList {
        boolean callNamingManager;

        NISBindingList(NamingEnumeration namingEnumeration, boolean bl) {
            super(namingEnumeration);
            this.callNamingManager = bl;
        }

        public Object next() throws NamingException {
            KeyValuePair keyValuePair = (KeyValuePair)this.keyvalues.next();
            String string = keyValuePair.getValue();
            String string2 = NISCtxRpc.this.getName(string);
            Object object = new NISObject(NISCtxRpc.this, string2, string, NISCtxRpc.this.environment);
            if (this.callNamingManager) {
                try {
                    CompositeName compositeName = new CompositeName();
                    compositeName.add(string2);
                    Attributes attributes = NISCtxRpc.this.getAttributesFromEntry(string2, string, null);
                    object = DirectoryManager.getObjectInstance(object, compositeName, NISCtxRpc.this, NISCtxRpc.this.environment, attributes);
                }
                catch (NamingException namingException) {
                    throw namingException;
                }
                catch (Exception exception) {
                    NamingException namingException = new NamingException("problem generating object using object factory");
                    namingException.setRootCause(exception);
                    throw namingException;
                }
            }
            return new Binding(string2, object);
        }
    }
}

