/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.nis;

import com.sun.jndi.nis.NISCtx;
import com.sun.jndi.nis.NISMap;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;

final class NISCtxHosts
extends NISCtx {
    private static final String addrMapname = "hosts.byaddr";
    private static final String[] hostsAttrIds = new String[]{"ipHostNumber", "dc", "cn", "description"};

    NISCtxHosts() {
        this.objectclass.add("ipHost");
    }

    public Attributes getAttributesFromEntry(String string, String string2, String[] stringArray) throws NamingException {
        BasicAttribute basicAttribute;
        String string3;
        boolean bl = stringArray == null;
        BasicAttributes basicAttributes = new BasicAttributes(true);
        if (!bl && stringArray.length == 0) {
            return basicAttributes;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
            if (bl || NISCtx.findId(stringArray, hostsAttrIds[0]) >= 0) {
                if (string3.indexOf(44) >= 0) {
                    basicAttribute = new BasicAttribute(hostsAttrIds[0]);
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
                    while (stringTokenizer2.hasMoreElements()) {
                        String string4 = (String)stringTokenizer2.nextElement();
                        basicAttribute.add(string4);
                    }
                    basicAttributes.put(basicAttribute);
                } else {
                    basicAttributes.put(hostsAttrIds[0], string3);
                }
            }
        }
        basicAttribute = new BasicAttribute(hostsAttrIds[2]);
        if (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
            basicAttribute.add(string3);
            if (bl || NISCtx.findId(stringArray, hostsAttrIds[1]) >= 0) {
                basicAttributes.put(hostsAttrIds[1], string3);
            }
        }
        while (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
            if (string3.charAt(0) == '#') {
                string3 = stringTokenizer.nextToken("\n").trim();
                if (string3.length() <= 0 || !bl && NISCtx.findId(stringArray, hostsAttrIds[3]) < 0) break;
                basicAttributes.put(hostsAttrIds[3], string3);
                break;
            }
            basicAttribute.add(string3);
        }
        if (basicAttribute.size() > 0 && (bl || NISCtx.findId(stringArray, hostsAttrIds[2]) >= 0)) {
            basicAttributes.put(basicAttribute);
        }
        if (bl || NISCtx.findId(stringArray, "nisMapEntry") >= 0) {
            basicAttributes.put("nisMapEntry", string2);
        }
        if (bl || NISCtx.findId(stringArray, "nisMapName") >= 0) {
            basicAttributes.put("nisMapName", this.realMapname);
        }
        if (bl || NISCtx.findId(stringArray, "objectClass") >= 0) {
            basicAttributes.put(this.objectclass);
        }
        return basicAttributes;
    }

    protected String getEntry(NISMap nISMap, String string, String[] stringArray) throws NamingException {
        boolean bl;
        String string2 = nISMap.getEntry(string);
        boolean bl2 = bl = stringArray == null || NISCtx.findId(stringArray, hostsAttrIds[3]) >= 0;
        if (!bl) {
            return string2;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            String string3 = stringTokenizer.nextToken();
            NISMap nISMap2 = new NISMap(this.domainName, this.hostName, this.getSecondaryMapname());
            return nISMap2.getEntry(string3);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    protected String getEntryName() {
        return hostsAttrIds[1];
    }

    protected String[] getIDs() {
        return hostsAttrIds;
    }

    protected Attribute getPrimaryAttribute(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        Attribute attribute = attributes.get(hostsAttrIds[2]);
        if (attribute != null) {
            return attribute;
        }
        return attributes.get(hostsAttrIds[1]);
    }

    protected Attribute getSecondaryAttribute(Attributes attributes) {
        if (attributes != null) {
            return attributes.get(hostsAttrIds[0]);
        }
        return null;
    }

    protected String getSecondaryMapname() {
        return addrMapname;
    }

    protected void initMapname(String string) {
        this.realMapname = "hosts.byname";
        this.mapname = "hosts.byname";
    }
}

