/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.internal.onc.rpc;

import com.sun.jndi.internal.onc.rpc.ReadThread;
import com.sun.jndi.internal.onc.rpc.VersionHelper;
import com.sun.jndi.internal.onc.rpc.dgpkt;
import com.sun.jndi.internal.onc.rpc.xdr_basic;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class xdr_dg
extends xdr_basic {
    private static VersionHelper helper = VersionHelper.getVersionHelper();
    static final int DG_BUFSIZ = 1024;
    private boolean my_peer;
    private ReadThread reader;
    private Object reader_lock;
    private InetAddress peer_ip;
    private int peer_port;
    private DatagramSocket peer_so_dg;
    protected InetAddress rx_ip;
    protected int rx_port;

    public xdr_dg(String string, int n) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("null/empty server name");
        }
        this.init(InetAddress.getByName(string), n, true);
        if (xdr_basic.trace) {
            System.err.println("inet addr " + this.peer_ip + " for host \"" + string + "\"");
        }
    }

    public xdr_dg(InetAddress inetAddress, int n) throws IOException {
        this.init(inetAddress, n, true);
        if (xdr_basic.trace) {
            System.err.println("inet addr " + this.peer_ip + " for host \"" + inetAddress.toString() + "\"");
        }
    }

    public void assert_full_frame() throws IOException {
        if (this.inindex != this.inbuffer.length && this.hard_assert_full_frame) {
            throw new IOException("partial frame processed");
        }
    }

    public void close() throws IOException {
        if (xdr_basic.trace) {
            System.err.println(String.valueOf(this.getClass().getName()) + ".close: call");
        }
        this.close_called = true;
        this.reader.closeit();
        this.reader = null;
    }

    protected void fillbuf() throws IOException {
        throw new IOException(String.valueOf(this.getClass().getName()) + ".fillbuf: EOF");
    }

    protected void flushbuf(boolean bl) throws IOException {
        throw new IOException(String.valueOf(this.getClass().getName()) + "output buffer overflow");
    }

    protected void init(InetAddress inetAddress, int n, boolean bl) throws IOException {
        this.outbuffer = new byte[1024];
        this.outindex = 0;
        this.peer_ip = inetAddress;
        this.peer_port = n;
        this.reader_lock = new Object();
        this.peer_so_dg = new DatagramSocket();
        this.my_peer = bl;
        this.reader = new ReadThread(this.reader_lock, this.peer_so_dg);
        Thread thread = helper.createThread(this.reader);
        thread.setDaemon(true);
        thread.start();
    }

    public boolean recv(long l) throws IOException {
        dgpkt dgpkt2 = this.reader.get_or_wait_pkt(l);
        this.rx_ip = dgpkt2.src_ip;
        this.rx_port = dgpkt2.src_port;
        byte[] byArray = dgpkt2.data;
        if (xdr_basic.trace) {
            if (byArray == null) {
                System.err.println("recv: returning null data");
            } else {
                System.err.println("recv: returning " + byArray.length + " bytes");
            }
        }
        if (byArray == null) {
            if (xdr_basic.trace) {
                System.err.println(String.valueOf(this.getClass().getName()) + ".recv: timed out ");
            }
            return false;
        }
        this.inbuffer = byArray;
        this.inindex = 0;
        return true;
    }

    protected void reset_inrecord() throws IOException {
        this.inbuffer = null;
        this.inindex = 0;
    }

    public void reset_outrecord() {
        this.outindex = 0;
    }

    public void send_record() throws IOException {
        int n = this.outindex;
        DatagramPacket datagramPacket = new DatagramPacket(this.outbuffer, n, this.peer_ip, this.peer_port);
        this.peer_so_dg.send(datagramPacket);
        if (xdr_basic.trace) {
            System.err.print(String.valueOf(this.getClass().getName()) + ".flushbuf: wrote ");
            System.err.println(String.valueOf(n) + " bytes:");
            System.err.print("[ ");
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.outbuffer[n2];
                if (n3 < 0) {
                    n3 += 256;
                }
                System.err.print(String.valueOf(Integer.toString(n3, 16)) + " ");
                ++n2;
            }
            System.err.println(" ]");
        }
    }
}

