/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.providers.java.RPCProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingRPCProvider
extends RPCProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger _log = LoggerFactory.getLogger(LoggingRPCProvider.class);

    protected Object invokeMethod(MessageContext msgContext, Method method, Object obj, Object[] args) throws Exception {
        String className = obj.getClass().getCanonicalName();
        String methodName = method.getName();
        _log.trace("Invoking {}#{} with {}", new Object[]{className, methodName, args});
        try {
            Object result = super.invokeMethod(msgContext, method, obj, args);
            if (method.getReturnType().equals(Void.TYPE)) {
                _log.trace("Invocation of {}#{} completed", (Object)className, (Object)methodName);
            } else if (result == null) {
                _log.trace("Invocation of {}#{} returned null", (Object)className, (Object)methodName);
            } else {
                _log.trace("Invocation of {}#{} returned {}: {}", new Object[]{className, methodName, result.getClass().getCanonicalName(), result});
            }
            return result;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof AxisFault) {
                AxisFault fault = (AxisFault)t;
                _log.trace("Invocation produced AxisFault {}: code={}, reason={}, string={}", new Object[]{((Object)((Object)fault)).getClass().getSimpleName(), fault.getFaultCode(), fault.getFaultReason(), fault.getFaultString()});
            } else if (t instanceof RuntimeException) {
                _log.error("Bug detected, please report this to support@dCache.org", t);
            } else {
                _log.error("Unexpected invocation exception", t);
            }
            throw e;
        }
        catch (RuntimeException e) {
            _log.error("Bug detected, please report this to support@dCache.org", (Throwable)e);
            throw e;
        }
    }
}

