/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.util;

import org.dcache.commons.util.NDC;
import org.slf4j.MDC;

public class JDC {
    public static final String MDC_SESSION = "cells.session";
    private static final String DELIM = ":";
    private static final long THREE_YEARS = 118719488L;
    private static long _last;
    private final NDC _ndc;
    private final String _session = JDC.getSession();

    public JDC() {
        this._ndc = NDC.cloneNdc();
    }

    private static void setMdc(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        } else {
            MDC.remove((String)key);
        }
    }

    public void apply() {
        JDC.setMdc(MDC_SESSION, this._session);
        if (this._ndc == null) {
            NDC.clear();
        } else {
            NDC.set((NDC)this._ndc);
        }
    }

    public static String getSession() {
        return MDC.get((String)MDC_SESSION);
    }

    public static void setSession(String session) {
        JDC.setMdc(MDC_SESSION, session);
    }

    public static void createSession(String prefix) {
        JDC.setSession(prefix + JDC.createUniq());
        NDC.push((String)JDC.getSession());
    }

    public static String createUniq() {
        _last = Math.max(_last + 1L, System.currentTimeMillis());
        return Long.toString(_last % 118719488L);
    }

    public static void push(String jid) {
        assert (JDC.getSession() != null);
        JDC.setSession(JDC.getSession() + DELIM + jid);
        NDC.pop();
        NDC.push((String)JDC.getSession());
    }

    public static void clear() {
        MDC.remove((String)MDC_SESSION);
        NDC.clear();
    }
}

