/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.util;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.SRM;
import org.dcache.srm.util.Configuration;

public class Axis {
    public static final String ATTRIBUTE_NAME_SRM = "org.dcache.srm.srm";
    public static final String ATTRIBUTE_NAME_STORAGE = "org.dcache.srm.storage";
    public static final String ATTRIBUTE_NAME_CONFIG = "org.dcache.srm.config";

    public static <T> T getAttribute(String key, Class<T> type) {
        MessageContext msgContext = MessageContext.getCurrentContext();
        HttpServlet servlet = (HttpServlet)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLET);
        ServletContext context = servlet.getServletContext();
        Object attribute = context.getAttribute(key);
        if (attribute == null) {
            throw new RuntimeException("Attribute " + key + " not found");
        }
        if (!type.isInstance(attribute)) {
            throw new RuntimeException("Attribute " + key + " not of type " + type);
        }
        return type.cast(attribute);
    }

    public static SRM getSRM() {
        return Axis.getAttribute(ATTRIBUTE_NAME_SRM, SRM.class);
    }

    public static AbstractStorageElement getStorage() {
        return Axis.getAttribute(ATTRIBUTE_NAME_STORAGE, AbstractStorageElement.class);
    }

    public static Configuration getConfiguration() {
        return Axis.getAttribute(ATTRIBUTE_NAME_CONFIG, Configuration.class);
    }
}

