/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.unixfs;

import org.dcache.srm.unixfs.UserAuthBase;

public class UserPwdRecord
extends UserAuthBase {
    String Password;

    public UserPwdRecord(String user, String passwd, boolean readOnly, int uid, int gid, String home, String root, String fsroot) {
        this(user, passwd, readOnly, uid, gid, home, root, fsroot, false);
    }

    public UserPwdRecord(String user, String passwd, boolean readOnly, int uid, int gid, String home, String root, String fsroot, boolean isPlain) {
        super(user, readOnly, uid, gid, home, root, fsroot);
        if (isPlain) {
            this.setPassword(passwd);
        } else {
            this.Password = passwd;
        }
    }

    @Override
    public boolean isWeak() {
        return true;
    }

    public String serialize() {
        String str = this.Username + " " + this.Password + " " + this.readOnlyStr() + " " + this.UID + " " + this.GID + " " + this.Home + " " + this.Root;
        if (!this.Root.equals(this.FsRoot)) {
            str = str + " " + this.FsRoot;
        }
        return str;
    }

    public String toString() {
        return this.serialize();
    }

    public String toDetailedString() {
        StringBuilder stringbuffer = new StringBuilder(" User Password Record for ");
        stringbuffer.append(this.Username).append(" :\n");
        stringbuffer.append("  Password Hash = ").append(this.Password).append('\n');
        stringbuffer.append("      read-only = ").append(this.readOnlyStr()).append("\n");
        stringbuffer.append("            UID = ").append(this.UID).append('\n');
        stringbuffer.append("            GID = ").append(this.GID).append('\n');
        stringbuffer.append("           Home = ").append(this.Home).append('\n');
        stringbuffer.append("           Root = ").append(this.Root).append('\n');
        stringbuffer.append("         FsRoot = ").append(this.FsRoot).append('\n');
        return stringbuffer.toString();
    }

    public String hashPassword(String pwd) {
        String uandp = "1234567890" + this.Username + " " + pwd;
        return Integer.toHexString(uandp.hashCode());
    }

    public void setPassword(String pwd) {
        this.Password = pwd.equals("-") ? "-" : this.hashPassword(pwd);
    }

    public void disable() {
        this.Password = "#";
    }

    public boolean passwordIsValid(String clear_pwd) {
        return this.Password.equals(this.hashPassword(clear_pwd));
    }

    public boolean isDisabled() {
        return this.Password.equals("#");
    }

    @Override
    public boolean isAnonymous() {
        return this.Password.equals("-");
    }

    public boolean isValid() {
        return this.Username != null && this.Password != null;
    }
}

