/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.unixfs;

import java.util.Collection;
import org.dcache.srm.unixfs.UserAuthBase;

public class UserAuthRecord
extends UserAuthBase {
    public Collection<String> principals;

    public UserAuthRecord(String user, boolean readOnly, int uid, int gid, String home, String root, String fsroot, Collection<String> principals) {
        super(user, readOnly, uid, gid, home, root, fsroot);
        this.principals = principals;
    }

    public UserAuthRecord() {
        super(null, true, -1, -1, "", "", "");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.Username);
        if (this.ReadOnly) {
            sb.append(" read-only");
        } else {
            sb.append(" read-write");
        }
        sb.append(' ').append(this.UID).append(' ');
        sb.append(this.GID).append(' ');
        sb.append(this.Home).append(' ');
        sb.append(this.Root).append(' ');
        sb.append(this.FsRoot).append('\n');
        if (this.principals != null) {
            for (String principal : this.principals) {
                sb.append("  ").append((Object)principal).append('\n');
            }
        }
        return sb.toString();
    }

    public String toDetailedString() {
        StringBuilder sb = new StringBuilder(" User Authentication Record for ");
        sb.append(this.Username).append(" :\n");
        sb.append("      read-only = ").append(this.readOnlyStr()).append("\n");
        sb.append("            UID = ").append(this.UID).append('\n');
        sb.append("            GID = ").append(this.GID).append('\n');
        sb.append("           Home = ").append(this.Home).append('\n');
        sb.append("           Root = ").append(this.Root).append('\n');
        sb.append("         FsRoot = ").append(this.FsRoot).append('\n');
        if (this.principals != null) {
            sb.append("         Secure Ids accepted by this user :\n");
            for (String principal : this.principals) {
                sb.append("    SecureId  = \"").append((Object)principal).append("\"\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isWeak() {
        return false;
    }

    public boolean hasSecureIdentity(String p) {
        if (this.principals != null) {
            return this.principals.contains(p);
        }
        return false;
    }

    public boolean isValid() {
        return this.Username != null;
    }

    public void addSecureIdentity(String id) {
        this.principals.add(id);
    }

    public void addSecureIdentities(Collection<String> ids) {
        ids.toArray(new String[ids.size()]);
        this.principals.addAll(ids);
    }

    public void removeSecureIdentities(Collection<String> ids) {
        ids.toArray(new String[ids.size()]);
        this.principals.removeAll(ids);
    }
}

