/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.dcache.auth.util.GSSUtils;
import org.dcache.srm.SRMAuthorization;
import org.dcache.srm.SRMAuthorizationException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.request.RequestCredentialStorage;
import org.dcache.srm.server.UserCredential;
import org.glite.voms.PKIVerifier;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrmAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(SrmAuthorizer.class);
    private static final String REMOTE_ADDR = "REMOTE_ADDR";
    private final RequestCredentialStorage storage;
    private final SRMAuthorization authorization;
    private final boolean isClientDNSLookup;

    public SrmAuthorizer(SRMAuthorization authorization, RequestCredentialStorage storage, boolean isClientDNSLookup) {
        this.isClientDNSLookup = isClientDNSLookup;
        this.authorization = authorization;
        this.storage = storage;
        log.debug("Successfully initialized");
    }

    public UserCredential getUserCredentials() throws SRMAuthorizationException {
        try {
            MessageContext mctx = MessageContext.getCurrentContext();
            this.setUpEnv(mctx);
            GSSContext gsscontext = (GSSContext)mctx.getProperty("org.globus.gsi.context");
            if (gsscontext == null) {
                throw new SRMAuthorizationException("cant extract gsscontext from MessageContext, gsscontext is null");
            }
            String secureId = gsscontext.getSrcName().toString();
            log.debug("User ID (secureId) is: " + secureId);
            GSSCredential delegcred = gsscontext.getDelegCred();
            if (delegcred != null) {
                try {
                    log.debug("User credential (delegcred) is: " + delegcred.getName());
                }
                catch (Exception e) {
                    log.debug("Caught occasional (usually harmless) exception when calling delegcred.getName()): ", (Throwable)e);
                }
            }
            UserCredential userCredential = new UserCredential();
            userCredential.secureId = secureId;
            userCredential.context = gsscontext;
            userCredential.credential = delegcred;
            String remote_addr = (String)mctx.getProperty(REMOTE_ADDR);
            userCredential.clientHost = this.isClientDNSLookup ? InetAddress.getByName(remote_addr).getCanonicalHostName() : remote_addr;
            return userCredential;
        }
        catch (UnknownHostException | GSSException e) {
            log.error("getUserCredentials failed with exception", (Throwable)e);
            throw new SRMAuthorizationException(e.toString(), e);
        }
    }

    public SRMUser getRequestUser(RequestCredential requestCredential, String role, GSSContext context) throws SRMAuthorizationException {
        MessageContext mctx = MessageContext.getCurrentContext();
        String remoteIP = (String)mctx.getProperty(REMOTE_ADDR);
        return this.authorization.authorize(requestCredential.getId(), requestCredential.getCredentialName(), role, context, remoteIP);
    }

    public RequestCredential getRequestCredential(UserCredential credential, String role) {
        try {
            String id = credential.secureId;
            GSSCredential gssCredential = credential.credential;
            log.debug("About to call RequestCredential.getRequestCredential({},{})", (Object)id, (Object)role);
            RequestCredential rc = RequestCredential.getRequestCredential(id, role);
            log.debug("Received RequestCredential: {}", (Object)rc);
            if (rc != null) {
                rc.keepBestDelegatedCredential(gssCredential);
            } else {
                log.debug("About to create new RequestCredential");
                rc = new RequestCredential(id, role, gssCredential, this.storage);
            }
            rc.saveCredential();
            log.debug("About to return RequestCredential = {}", (Object)rc);
            return rc;
        }
        catch (SQLException | GSSException e) {
            throw new RuntimeException("Problem getting request credential", e);
        }
    }

    private void setUpEnv(MessageContext msgContext) {
        Object tmp = msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (tmp == null || !(tmp instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)tmp;
        if ((tmp = req.getAttribute("org.globus.gsi.context")) != null) {
            msgContext.setProperty("org.globus.gsi.context", tmp);
        }
        if ((tmp = req.getRemoteAddr()) != null) {
            msgContext.setProperty(REMOTE_ADDR, tmp);
        }
    }

    static Collection<String> getFQANsFromContext(ExtendedGSSContext gssContext, PKIVerifier pkiVerifier) throws SRMAuthorizationException {
        try {
            return GSSUtils.getFQANsFromGSSContext((ExtendedGSSContext)gssContext, (PKIVerifier)pkiVerifier);
        }
        catch (AuthorizationException ae) {
            log.error("Could not extract FQANs from context", (Throwable)ae);
            throw new SRMAuthorizationException("Could not extract FQANs from context " + ae.getMessage());
        }
    }
}

