/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.security;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.globus.gsi.CredentialException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.X509Credential;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.gsi.gssapi.net.impl.GSIGssSocket;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class DelegationTestClient {
    private String middleServerHost;
    private int middleServerPort;
    private String destServerHost;
    private int destServerPort;
    private String proxy;

    public void say(String s) {
        System.out.println(s);
    }

    public void esay(String s) {
        System.err.println(s);
    }

    public void esay(Throwable t) {
        t.printStackTrace();
    }

    public static GSSCredential createUserCredential(String x509UserProxy) throws CredentialException, GSSException {
        if (x509UserProxy != null) {
            X509Credential gcred = new X509Credential(x509UserProxy);
            GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(gcred, 1);
            return cred;
        }
        X509Credential gcred = X509Credential.getDefaultCredential();
        GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(gcred, 1);
        return cred;
    }

    public Socket createSocket(InetAddress inetAddress, int port, String x509UserProxy) throws IOException {
        this.say("createSocket(" + inetAddress + "," + port + ")");
        Socket s = null;
        try {
            GSSCredential credential = DelegationTestClient.createUserCredential(x509UserProxy);
            if (credential == null) {
                this.esay("createSocket: credential is null !!!");
                throw new IOException("credential is null !!!");
            }
            this.say("createSocket() user credential is " + credential.getName());
            GSSManager manager = ExtendedGSSManager.getInstance();
            HostAuthorization gssAuth = HostAuthorization.getInstance();
            GSSName targetName = gssAuth.getExpectedName(null, inetAddress.getCanonicalHostName());
            ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(targetName, GSSConstants.MECH_OID, credential, 0);
            context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
            context.requestCredDeleg(true);
            context.setOption(GSSConstants.DELEGATION_TYPE, (Object)GSIConstants.DELEGATION_TYPE_FULL);
            s = new Socket(inetAddress, port);
            GSIGssSocket gsiSocket = new GSIGssSocket(s, (GSSContext)context);
            gsiSocket.setUseClientMode(true);
            gsiSocket.setAuthorization((Authorization)gssAuth);
            gsiSocket.setWrapMode(1);
            gsiSocket.startHandshake();
            s = gsiSocket;
        }
        catch (Exception e) {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw new IOException(e.toString());
        }
        return s;
    }

    public DelegationTestClient(String middleServerHost, int middleServerPort, String destServerHost, int destServerPort, String proxy) {
        this.middleServerHost = middleServerHost;
        this.middleServerPort = middleServerPort;
        this.destServerHost = destServerHost;
        this.destServerPort = destServerPort;
        this.proxy = proxy;
    }

    public void delegate() throws IOException {
        Socket s = this.createSocket(InetAddress.getByName(this.middleServerHost), this.middleServerPort, this.proxy);
        this.say("connected to " + s);
        DataOutputStream outStream = new DataOutputStream(s.getOutputStream());
        outStream.writeUTF(this.destServerHost + " " + this.destServerPort);
        this.say("wrote " + this.destServerHost + " " + this.destServerPort);
        outStream.close();
    }

    public static final void main(String[] args) throws IOException {
        String middleServerHost = args[0];
        int middleServerPort = Integer.parseInt(args[1]);
        String destServerHost = args[2];
        int destServerPort = Integer.parseInt(args[3]);
        String proxy = args.length > 4 ? args[4] : null;
        DelegationTestClient client = new DelegationTestClient(middleServerHost, middleServerPort, destServerHost, destServerPort, proxy);
        client.delegate();
    }
}

