/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.srm.scheduler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dcache.srm.request.Job;
import org.dcache.srm.scheduler.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedMemoryCache {
    private static final Logger _log = LoggerFactory.getLogger(SharedMemoryCache.class);
    private final ReentrantReadWriteLock sharedMemoryReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock sharedMemoryReadLock = this.sharedMemoryReadWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock sharedMemoryWriteLock = this.sharedMemoryReadWriteLock.writeLock();
    private Map<Long, Job> sharedMemoryCache = new HashMap<Long, Job>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSharedMemoryChache(Job job) {
        if (job == null) {
            return;
        }
        State state = job.getState();
        this.sharedMemoryWriteLock.lock();
        try {
            boolean cached = this.sharedMemoryCache.containsKey(job.getId());
            _log.debug("updateSharedMemoryChache for job =" + job.getId() + " state=" + (Object)((Object)state) + " cached =" + cached);
            if (cached && state.isFinalState()) {
                _log.debug("removing job #" + job.getId() + " from memory cache");
                this.sharedMemoryCache.remove(job.getId());
            }
            if (!cached && !state.isFinalState()) {
                _log.debug("putting job #" + job.getId() + " to memory cache");
                this.sharedMemoryCache.put(job.getId(), job);
            }
        }
        finally {
            this.sharedMemoryWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getJob(Long jobId) {
        _log.debug("getJob ( " + jobId + " ) ");
        this.sharedMemoryReadLock.lock();
        try {
            Job job = this.sharedMemoryCache.get(jobId);
            return job;
        }
        finally {
            this.sharedMemoryReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.sharedMemoryWriteLock.lock();
        try {
            this.sharedMemoryCache.clear();
        }
        finally {
            this.sharedMemoryWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Job> Set<T> getJobs(Class<T> jobType) {
        this.sharedMemoryReadLock.lock();
        try {
            HashSet<Job> results = new HashSet<Job>();
            for (Job job : this.sharedMemoryCache.values()) {
                if (!job.getClass().equals(jobType)) continue;
                results.add(job);
            }
            HashSet<Job> hashSet = results;
            return hashSet;
        }
        finally {
            this.sharedMemoryReadLock.unlock();
        }
    }
}

